/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.security.oauth.linkedin;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.organization.UserProfile;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.security.oauth.exception.OAuthException;
import org.gatein.security.oauth.exception.OAuthExceptionCode;
import org.gatein.security.oauth.linkedin.LinkedinAccessTokenContext;
import org.gatein.security.oauth.linkedin.LinkedinProcessor;
import org.gatein.security.oauth.spi.InteractionState;
import org.gatein.security.oauth.spi.OAuthCodec;
import org.gatein.security.oauth.utils.OAuthPersistenceUtils;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.LinkedInApi;
import org.scribe.model.Token;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;

public class LinkedinProcessorImpl
implements LinkedinProcessor {
    private static Logger log = LoggerFactory.getLogger(LinkedinProcessorImpl.class);
    private final String redirectURL;
    private final String apiKey;
    private final String apiSecret;
    private final int chunkLength;
    private OAuthService oAuthService;

    public LinkedinProcessorImpl(ExoContainerContext context, InitParams params) {
        this.apiKey = params.getValueParam("apiKey").getValue();
        this.apiSecret = params.getValueParam("apiSecret").getValue();
        String redirectURLParam = params.getValueParam("redirectURL").getValue();
        if (this.apiKey == null || this.apiKey.length() == 0 || this.apiKey.trim().equals("<<to be replaced>>")) {
            throw new IllegalArgumentException("Property 'clientId' needs to be provided. The value should be clientId of your Twitter application");
        }
        if (this.apiSecret == null || this.apiSecret.length() == 0 || this.apiSecret.trim().equals("<<to be replaced>>")) {
            throw new IllegalArgumentException("Property 'clientSecret' needs to be provided. The value should be clientSecret of your Twitter application");
        }
        this.redirectURL = redirectURLParam == null || redirectURLParam.length() == 0 ? "http://localhost:8080/" + context.getName() + "/twitterAuth" : redirectURLParam.replaceAll("@@portal.container.name@@", context.getName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("configuration: apiKey=" + this.apiKey + ", apiSecret=" + this.apiSecret + ", redirectURL=" + this.redirectURL));
        }
        this.chunkLength = OAuthPersistenceUtils.getChunkLength(params);
        this.oAuthService = new ServiceBuilder().provider(LinkedInApi.class).apiKey(this.apiKey).apiSecret(this.apiSecret).callback(this.redirectURL).build();
    }

    @Override
    public InteractionState<LinkedinAccessTokenContext> processOAuthInteraction(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, OAuthException {
        HttpSession session = httpRequest.getSession();
        Token requestToken = (Token)session.getAttribute("_linkedinRequestToken");
        if (requestToken == null) {
            requestToken = this.oAuthService.getRequestToken();
            String redirect = this.oAuthService.getAuthorizationUrl(requestToken);
            this.oAuthService.getRequestToken();
            httpResponse.sendRedirect(redirect);
            session.setAttribute("_linkedinRequestToken", (Object)requestToken);
            return new InteractionState<Object>(InteractionState.State.AUTH, null);
        }
        session.removeAttribute("_linkedinRequestToken");
        String verifierCode = httpRequest.getParameter("oauth_verifier");
        if (verifierCode != null) {
            Verifier verifier = new Verifier(verifierCode);
            Token accessToken = this.oAuthService.getAccessToken(requestToken, verifier);
            LinkedinAccessTokenContext accessTokenContext = new LinkedinAccessTokenContext(accessToken, this.oAuthService);
            return new InteractionState<LinkedinAccessTokenContext>(InteractionState.State.FINISH, accessTokenContext);
        }
        String oauthProblem = httpRequest.getParameter("oauth_problem");
        if ("user_refused".equals(oauthProblem)) {
            throw new OAuthException(OAuthExceptionCode.USER_DENIED_SCOPE, "User denied scope on LinkedIn authorization page");
        }
        throw new OAuthException(OAuthExceptionCode.LINKEDIN_ERROR, "Can not get oauth verifier code from LinkedIn");
    }

    @Override
    public InteractionState<LinkedinAccessTokenContext> processOAuthInteraction(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String scope) throws IOException, OAuthException {
        this.oAuthService = scope != null ? new ServiceBuilder().provider(LinkedInApi.class).apiKey(this.apiKey).apiSecret(this.apiSecret).scope(scope).callback(this.redirectURL).build() : new ServiceBuilder().provider(LinkedInApi.class).apiKey(this.apiKey).apiSecret(this.apiSecret).callback(this.redirectURL).build();
        return this.processOAuthInteraction(httpRequest, httpResponse);
    }

    @Override
    public void revokeToken(LinkedinAccessTokenContext accessToken) throws OAuthException {
    }

    @Override
    public LinkedinAccessTokenContext validateTokenAndUpdateScopes(LinkedinAccessTokenContext accessToken) throws OAuthException {
        return accessToken;
    }

    @Override
    public <C> C getAuthorizedSocialApiObject(LinkedinAccessTokenContext accessToken, Class<C> socialApiObjectType) {
        return null;
    }

    @Override
    public void saveAccessTokenAttributesToUserProfile(UserProfile userProfile, OAuthCodec codec, LinkedinAccessTokenContext accessToken) {
        String encodedAccessToken = codec.encodeString(accessToken.accessToken.getToken());
        String encodedAccessTokenSecret = codec.encodeString(accessToken.accessToken.getSecret());
        OAuthPersistenceUtils.saveLongAttribute(encodedAccessToken, userProfile, "user.social-info.linkedin.accessToken", false, this.chunkLength);
        OAuthPersistenceUtils.saveLongAttribute(encodedAccessTokenSecret, userProfile, "user.social-info.linkedin.accessTokenSecret", false, this.chunkLength);
    }

    @Override
    public LinkedinAccessTokenContext getAccessTokenFromUserProfile(UserProfile userProfile, OAuthCodec codec) {
        String encodedAccessToken = OAuthPersistenceUtils.getLongAttribute(userProfile, "user.social-info.linkedin.accessToken", false);
        String encodedAccessTokenSecret = OAuthPersistenceUtils.getLongAttribute(userProfile, "user.social-info.linkedin.accessTokenSecret", false);
        String decodedAccessToken = codec.decodeString(encodedAccessToken);
        String decodedAccessTokenSecret = codec.decodeString(encodedAccessTokenSecret);
        if (decodedAccessToken == null || decodedAccessTokenSecret == null) {
            return null;
        }
        Token token = new Token(decodedAccessToken, decodedAccessTokenSecret);
        return new LinkedinAccessTokenContext(token, this.oAuthService);
    }

    @Override
    public void removeAccessTokenFromUserProfile(UserProfile userProfile) {
        OAuthPersistenceUtils.removeLongAttribute(userProfile, "user.social-info.linkedin.accessToken", false);
        OAuthPersistenceUtils.removeLongAttribute(userProfile, "user.social-info.linkedin.accessTokenSecret", false);
    }
}

