/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.controller.resource;

import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSSourceFile;
import com.google.javascript.jscomp.LoggerErrorManager;
import com.google.javascript.jscomp.Result;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Logger;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.utils.CharsetTextEncoder;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.commons.utils.TextEncoder;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.gatein.common.io.IOTools;
import org.gatein.portal.controller.resource.ResourceRequestHandler;
import org.gatein.portal.controller.resource.ScriptKey;
import org.gatein.portal.controller.resource.ScriptResult;

class ScriptLoader
implements Loader<ScriptKey, ScriptResult, ControllerContext> {
    ScriptLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptResult retrieve(ControllerContext context, ScriptKey key) throws Exception {
        JavascriptConfigService service = (JavascriptConfigService)PortalContainer.getComponent(JavascriptConfigService.class);
        Reader script = service.getScript(key.id, key.locale);
        String sourceName = (Object)((Object)key.id.getScope()) + "/" + key.id.getName() + ".js";
        if (script != null) {
            if (key.minified) {
                CompilationLevel level = CompilationLevel.SIMPLE_OPTIMIZATIONS;
                CompilerOptions options = new CompilerOptions();
                level.setOptionsForCompilationLevel(options);
                Compiler compiler = new Compiler();
                compiler.setErrorManager((ErrorManager)new LoggerErrorManager(Logger.getLogger(ResourceRequestHandler.class.getName())));
                StringWriter code = new StringWriter();
                IOTools.copy((Reader)script, (Writer)code);
                JSSourceFile[] inputs = new JSSourceFile[]{JSSourceFile.fromCode((String)sourceName, (String)code.toString())};
                Result res = compiler.compile(new JSSourceFile[0], inputs, options);
                if (res.success) {
                    script = new StringReader(compiler.toSource());
                } else {
                    StringBuilder msg = new StringBuilder("Handle me gracefully JS errors\n");
                    for (JSError error : res.errors) {
                        msg.append(error.sourceName).append(":").append(error.lineNumber).append(" ").append(error.description).append("\n");
                    }
                    return new ScriptResult.Error(msg.toString());
                }
            }
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                TextEncoder encoder = CharsetTextEncoder.getUTF8();
                char[] buffer = new char[256];
                int l = script.read(buffer);
                while (l != -1) {
                    encoder.encode(buffer, 0, l, (OutputStream)out);
                    l = script.read(buffer);
                }
                ScriptResult.Resolved resolved = new ScriptResult.Resolved(out.toByteArray());
                return resolved;
            }
            finally {
                Safe.close((Closeable)script);
            }
        }
        return ScriptResult.NOT_FOUND;
    }
}

