/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application.javascript;

import java.io.Closeable;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.javascript.JavascriptConfigParser;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.gatein.wci.WebApp;
import org.gatein.wci.WebAppEvent;
import org.gatein.wci.WebAppLifeCycleEvent;
import org.gatein.wci.WebAppListener;

public class JavascriptConfigDeployer
implements WebAppListener {
    private static final String GATEIN_CONFIG_RESOURCE = "/WEB-INF/gatein-resources.xml";
    private static final Log LOG = ExoLogger.getLogger(JavascriptConfigDeployer.class);
    private final JavascriptConfigService javascriptService;
    private final String portalContainerName;

    public JavascriptConfigDeployer(String portalContainerName, JavascriptConfigService javascriptService) {
        this.javascriptService = javascriptService;
        this.portalContainerName = portalContainerName;
    }

    public void onEvent(WebAppEvent event) {
        if (event instanceof WebAppLifeCycleEvent) {
            WebAppLifeCycleEvent lifeCycleEvent = (WebAppLifeCycleEvent)event;
            ServletContext servletContext = lifeCycleEvent.getWebApp().getServletContext();
            switch (lifeCycleEvent.getType()) {
                case 1: {
                    this.add(event.getWebApp());
                    break;
                }
                case 0: {
                    this.remove(event.getWebApp());
                }
            }
        }
    }

    private void add(final WebApp webApp) {
        try {
            InputStream is = webApp.getServletContext().getResourceAsStream(GATEIN_CONFIG_RESOURCE);
            if (is == null) {
                return;
            }
            Safe.close((Closeable)is);
            RootContainer.PortalContainerPostInitTask task = new RootContainer.PortalContainerPostInitTask(){

                public void execute(ServletContext scontext, PortalContainer portalContainer) {
                    JavascriptConfigDeployer.this.register(scontext, portalContainer);
                    JavascriptConfigDeployer.this.javascriptService.registerContext(webApp);
                }
            };
            PortalContainer.addInitTask((ServletContext)webApp.getServletContext(), (RootContainer.PortalContainerInitTask)task, (String)this.portalContainerName);
        }
        catch (Exception ex) {
            LOG.error((Object)("An error occurs while registering 'Javascript in gatein-resources.xml' from the context '" + (webApp.getServletContext() == null ? "unknown" : webApp.getServletContext().getServletContextName()) + "'"), (Throwable)ex);
        }
    }

    private void remove(WebApp webApp) {
        this.javascriptService.unregisterServletContext(webApp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(ServletContext scontext, PortalContainer container) {
        InputStream is = null;
        try {
            is = scontext.getResourceAsStream(GATEIN_CONFIG_RESOURCE);
            JavascriptConfigParser.processConfigResource(is, this.javascriptService, scontext);
        }
        catch (Exception ex) {
            LOG.error((Object)("An error occurs while processing 'Javascript in gatein-resources.xml' from the context '" + scontext.getServletContextName() + "'"), (Throwable)ex);
        }
        finally {
            Safe.close((Closeable)is);
        }
    }
}

