/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application.javascript;

import org.gatein.portal.controller.resource.ResourceId;
import org.gatein.portal.controller.resource.script.Module;
import org.gatein.portal.controller.resource.script.ScriptResource;

public abstract class Javascript {
    protected final ResourceId resource;
    protected final String contextPath;
    protected final int priority;

    public static Javascript create(ResourceId resource, String path, String contextPath, int priority) {
        if (path.startsWith("http://") || path.startsWith("https://")) {
            return new Remote(resource, contextPath, path, priority);
        }
        return new Local(resource, contextPath, path, null, priority);
    }

    public static Javascript create(Module module) {
        if (module instanceof Module.Remote) {
            Module.Remote remote = (Module.Remote)module;
            return new Remote(module.getResource().getId(), remote.getContextPath(), remote.getURI(), remote.getPriority());
        }
        Module.Local local = (Module.Local)module;
        return new Local(local.getResource().getId(), local.getContextPath(), local.getContents(), local.getResourceBundle(), local.getPriority());
    }

    private Javascript(ResourceId resource, String contextPath, int priority) {
        this.resource = resource;
        this.contextPath = contextPath;
        this.priority = priority < 0 ? Integer.MAX_VALUE : priority;
    }

    public ResourceId getResource() {
        return this.resource;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public int getPriority() {
        return this.priority;
    }

    abstract Module addModuleTo(ScriptResource var1);

    public abstract boolean isExternalScript();

    public static class Remote
    extends Javascript {
        protected final String uri;

        public Remote(ResourceId resource, String contextPath, String uri, int priority) {
            super(resource, contextPath, priority);
            this.uri = uri;
        }

        @Override
        Module addModuleTo(ScriptResource resource) {
            return resource.addRemoteModule(this.contextPath, this.uri, this.priority);
        }

        @Override
        public boolean isExternalScript() {
            return true;
        }
    }

    public static class Local
    extends Javascript {
        protected final Module.Local.Content[] contents;
        protected final String resourceBundle;

        public Local(ResourceId resource, String contextPath, String path, String resourceBundle, int priority) {
            this(resource, contextPath, new Module.Local.Content[]{new Module.Local.Content(path)}, resourceBundle, priority);
        }

        public Local(ResourceId resource, String contextPath, Module.Local.Content[] contents, String resourceBundle, int priority) {
            super(resource, contextPath, priority);
            if (contents == null) {
                throw new IllegalArgumentException("contents must be not null");
            }
            this.contents = contents;
            this.resourceBundle = resourceBundle;
        }

        @Override
        Module addModuleTo(ScriptResource resource) {
            return resource.addLocalModule(this.contextPath, this.contents, this.resourceBundle, this.priority);
        }

        public Module.Local.Content[] getContents() {
            return this.contents;
        }

        public String getResourceBundle() {
            return this.resourceBundle;
        }

        @Override
        public boolean isExternalScript() {
            return false;
        }
    }
}

