/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.security;

import java.util.Collection;
import java.util.Date;
import org.chromattic.api.ChromatticSession;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.commons.chromattic.ContextualTask;
import org.exoplatform.commons.chromattic.SessionContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.web.security.GateInToken;
import org.exoplatform.web.security.security.AbstractCodec;
import org.exoplatform.web.security.security.AbstractTokenService;
import org.exoplatform.web.security.security.ToThrowAwayCodec;
import org.exoplatform.web.security.security.TokenContainer;
import org.exoplatform.web.security.security.TokenEntry;
import org.exoplatform.web.security.security.TokenExistsException;
import org.gatein.wci.security.Credentials;

public class CookieTokenService
extends AbstractTokenService<GateInToken, String> {
    public static final String LIFECYCLE_NAME = "lifecycle-name";
    private ChromatticLifeCycle chromatticLifeCycle;
    private String lifecycleName = "autologin";
    private AbstractCodec codec;

    public CookieTokenService(InitParams initParams, ChromatticManager chromatticManager) {
        super(initParams);
        if (initParams.getValuesParam("service.configuration").getValues().size() > 3) {
            this.lifecycleName = (String)initParams.getValuesParam("service.configuration").getValues().get(3);
        }
        this.chromatticLifeCycle = chromatticManager.getLifeCycle(this.lifecycleName);
        this.codec = new ToThrowAwayCodec();
    }

    public final void setupCodec(ComponentPlugin codecPlugin) {
        if (codecPlugin instanceof AbstractCodec) {
            this.codec = (AbstractCodec)codecPlugin;
        }
    }

    @Override
    public String createToken(final Credentials credentials) {
        if (this.validityMillis < 0L) {
            throw new IllegalArgumentException();
        }
        if (credentials == null) {
            throw new NullPointerException();
        }
        return (String)new TokenTask<String>(){

            @Override
            protected String execute() {
                String tokenId = null;
                while (tokenId == null) {
                    tokenId = CookieTokenService.this.nextTokenId();
                    long expirationTimeMillis = System.currentTimeMillis() + CookieTokenService.this.validityMillis;
                    GateInToken token = new GateInToken(expirationTimeMillis, credentials);
                    TokenContainer container = this.getTokenContainer();
                    try {
                        container.encodeAndSaveToken(tokenId, token.getPayload(), new Date(expirationTimeMillis), CookieTokenService.this.codec);
                    }
                    catch (TokenExistsException tee) {
                        CookieTokenService.this.log.debug((Object)("Token " + tokenId + " already exists. Other token will be generated"));
                        tokenId = null;
                    }
                }
                return tokenId;
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    @Override
    public GateInToken getToken(final String id) {
        return (GateInToken)new TokenTask<GateInToken>(){

            @Override
            protected GateInToken execute() {
                return this.getTokenContainer().getTokenAndDecode(id, CookieTokenService.this.codec);
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    @Override
    public GateInToken deleteToken(final String id) {
        return (GateInToken)new TokenTask<GateInToken>(){

            @Override
            protected GateInToken execute() {
                return this.getTokenContainer().removeToken(id);
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    public String[] getAllTokens() {
        return (String[])new TokenTask<String[]>(){

            @Override
            protected String[] execute() {
                TokenContainer container = this.getTokenContainer();
                Collection<TokenEntry> tokens = container.getAllTokens();
                String[] ids = new String[tokens.size()];
                int count = 0;
                for (TokenEntry token : tokens) {
                    ids[count++] = token.getId();
                }
                return ids;
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    @Override
    public long size() {
        return (Long)new TokenTask<Long>(){

            @Override
            protected Long execute() {
                TokenContainer container = this.getTokenContainer();
                Collection<TokenEntry> tokens = container.getAllTokens();
                return tokens.size();
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    @Override
    protected String decodeKey(String stringKey) {
        return stringKey;
    }

    private abstract class TokenTask<V>
    extends ContextualTask<V> {
        private TokenTask() {
        }

        protected final TokenContainer getTokenContainer() {
            SessionContext ctx = CookieTokenService.this.chromatticLifeCycle.getContext();
            ChromatticSession session = ctx.getSession();
            TokenContainer container = (TokenContainer)session.findByPath(TokenContainer.class, CookieTokenService.this.lifecycleName);
            if (container == null) {
                container = (TokenContainer)session.insert(TokenContainer.class, CookieTokenService.this.lifecycleName);
            }
            return container;
        }

        protected V execute(SessionContext context) {
            return this.execute();
        }

        protected abstract V execute();
    }
}

