/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.security;

import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.web.security.GateInToken;
import org.exoplatform.web.security.security.AbstractTokenService;
import org.gatein.wci.security.Credentials;

public class TransientTokenService
extends AbstractTokenService<GateInToken, String> {
    protected final ConcurrentHashMap<String, GateInToken> tokens = new ConcurrentHashMap();

    public TransientTokenService(InitParams initParams) {
        super(initParams);
    }

    @Override
    public String createToken(Credentials credentials) {
        if (this.validityMillis < 0L) {
            throw new IllegalArgumentException();
        }
        if (credentials == null) {
            throw new NullPointerException();
        }
        String tokenId = this.nextTokenId();
        long expirationTimeMillis = System.currentTimeMillis() + this.validityMillis;
        this.tokens.put(tokenId, new GateInToken(expirationTimeMillis, credentials));
        return tokenId;
    }

    @Override
    public GateInToken getToken(String id) {
        return this.tokens.get(id);
    }

    @Override
    protected String decodeKey(String stringKey) {
        return stringKey;
    }

    @Override
    public GateInToken deleteToken(String id) {
        GateInToken token = this.tokens.get(id);
        this.tokens.remove(id);
        return token;
    }

    public String[] getAllTokens() {
        return this.tokens.keySet().toArray(new String[0]);
    }

    @Override
    public long size() {
        return this.tokens.size();
    }
}

