/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security;

import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.web.security.AbstractTokenServiceTest;
import org.exoplatform.web.security.GateInToken;
import org.exoplatform.web.security.security.CookieTokenService;
import org.gatein.wci.security.Credentials;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/tokenservice-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.test.jcr-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/jcr-configuration.xml")})
public abstract class AbstractCookieTokenServiceTest
extends AbstractTokenServiceTest<CookieTokenService> {
    protected void setUp() throws Exception {
        this.service = this.createService();
        Thread.sleep(1000L);
    }

    protected abstract CookieTokenService createService();

    @Override
    public void testGetToken() throws Exception {
        String tokenId = ((CookieTokenService)this.service).createToken(new Credentials("root", "gtn"));
        AbstractCookieTokenServiceTest.assertEquals((long)((CookieTokenService)this.service).getValidityTime(), (long)2L);
        GateInToken token = ((CookieTokenService)this.service).getToken(tokenId);
        AbstractCookieTokenServiceTest.assertEquals((String)token.getPayload().getUsername(), (String)"root");
        AbstractCookieTokenServiceTest.assertEquals((String)token.getPayload().getPassword(), (String)"gtn");
        ((CookieTokenService)this.service).deleteToken(tokenId);
    }

    @Override
    public void testGetAllToken() throws Exception {
    }

    @Override
    public void testSize() throws Exception {
        String token = ((CookieTokenService)this.service).createToken(new Credentials("root", "gtn"));
        AbstractCookieTokenServiceTest.assertEquals((long)((CookieTokenService)this.service).size(), (long)1L);
        ((CookieTokenService)this.service).deleteToken(token);
    }

    @Override
    public void testDeleteToken() throws Exception {
        String tokenId = ((CookieTokenService)this.service).createToken(new Credentials("root", "gtn"));
        AbstractCookieTokenServiceTest.assertNotSame((Object)((CookieTokenService)this.service).getToken(tokenId), (Object)((CookieTokenService)this.service).deleteToken(tokenId));
        AbstractCookieTokenServiceTest.assertNull((Object)((CookieTokenService)this.service).getToken(tokenId));
        AbstractCookieTokenServiceTest.assertEquals((long)((CookieTokenService)this.service).size(), (long)0L);
        ((CookieTokenService)this.service).deleteToken(tokenId);
    }

    @Override
    public void testCleanExpiredTokens() throws Exception {
        AbstractCookieTokenServiceTest.assertEquals((long)((CookieTokenService)this.service).getValidityTime(), (long)2L);
        ((CookieTokenService)this.service).createToken(new Credentials("user1", "gtn"));
        Thread.sleep(1000L);
        ((CookieTokenService)this.service).createToken(new Credentials("user2", "gtn"));
        AbstractCookieTokenServiceTest.assertEquals((long)((CookieTokenService)this.service).size(), (long)2L);
        Thread.sleep(1500L);
        ((CookieTokenService)this.service).cleanExpiredTokens();
        AbstractCookieTokenServiceTest.assertEquals((long)((CookieTokenService)this.service).size(), (long)1L);
    }
}

