/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security;

import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.web.security.AbstractTokenServiceTest;
import org.exoplatform.web.security.GateInToken;
import org.exoplatform.web.security.security.TransientTokenService;
import org.gatein.wci.security.Credentials;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/tokenservice-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.test.jcr-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/jcr-configuration.xml")})
public class TestTransientTokenService
extends AbstractTokenServiceTest<TransientTokenService> {
    protected void setUp() throws Exception {
        PortalContainer container = this.getContainer();
        this.service = (TransientTokenService)container.getComponentInstanceOfType(TransientTokenService.class);
    }

    @Override
    public void testGetToken() throws Exception {
        String tokenId = ((TransientTokenService)this.service).createToken(new Credentials("root", "gtn"));
        TestTransientTokenService.assertEquals((long)((TransientTokenService)this.service).getValidityTime(), (long)2L);
        GateInToken token = ((TransientTokenService)this.service).getToken(tokenId);
        TestTransientTokenService.assertEquals((String)token.getPayload().getUsername(), (String)"root");
        TestTransientTokenService.assertEquals((String)token.getPayload().getPassword(), (String)"gtn");
        ((TransientTokenService)this.service).deleteToken(tokenId);
    }

    @Override
    public void testGetAllToken() throws Exception {
        String tokenId1 = ((TransientTokenService)this.service).createToken(new Credentials("root1", "gtn1"));
        String tokenId2 = ((TransientTokenService)this.service).createToken(new Credentials("root2", "gtn2"));
        String[] tokens = ((TransientTokenService)this.service).getAllTokens();
        TestTransientTokenService.assertEquals((int)tokens.length, (int)2);
        GateInToken token1 = ((TransientTokenService)this.service).getToken(tokenId1);
        TestTransientTokenService.assertEquals((String)token1.getPayload().getUsername(), (String)"root1");
        TestTransientTokenService.assertEquals((String)token1.getPayload().getPassword(), (String)"gtn1");
        GateInToken token2 = ((TransientTokenService)this.service).getToken(tokenId2);
        TestTransientTokenService.assertEquals((String)token2.getPayload().getUsername(), (String)"root2");
        TestTransientTokenService.assertEquals((String)token2.getPayload().getPassword(), (String)"gtn2");
        ((TransientTokenService)this.service).deleteToken(tokenId1);
        ((TransientTokenService)this.service).deleteToken(tokenId2);
    }

    @Override
    public void testSize() throws Exception {
        String tokenId1 = ((TransientTokenService)this.service).createToken(new Credentials("root1", "gtn1"));
        TestTransientTokenService.assertEquals((long)((TransientTokenService)this.service).size(), (long)1L);
        ((TransientTokenService)this.service).deleteToken(tokenId1);
    }

    @Override
    public void testDeleteToken() throws Exception {
        String tokenId = ((TransientTokenService)this.service).createToken(new Credentials("root", "gtn"));
        ((TransientTokenService)this.service).deleteToken(tokenId);
        TestTransientTokenService.assertNull((Object)((TransientTokenService)this.service).getToken(tokenId));
    }

    @Override
    public void testCleanExpiredTokens() throws Exception {
        TestTransientTokenService.assertEquals((long)((TransientTokenService)this.service).getValidityTime(), (long)2L);
        ((TransientTokenService)this.service).createToken(new Credentials("user1", "gtn"));
        Thread.sleep(1000L);
        ((TransientTokenService)this.service).createToken(new Credentials("user2", "gtn"));
        TestTransientTokenService.assertEquals((long)((TransientTokenService)this.service).size(), (long)2L);
        Thread.sleep(1500L);
        ((TransientTokenService)this.service).cleanExpiredTokens();
        TestTransientTokenService.assertEquals((long)((TransientTokenService)this.service).size(), (long)1L);
    }
}

