/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.web.AbstractHttpServlet;
import org.exoplatform.web.security.AuthenticationRegistry;
import org.exoplatform.web.security.security.AbstractTokenService;
import org.exoplatform.web.security.security.CookieTokenService;
import org.exoplatform.web.security.sso.SSOHelper;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.wci.ServletContainer;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.authentication.AuthenticationEvent;
import org.gatein.wci.authentication.AuthenticationEventType;
import org.gatein.wci.authentication.AuthenticationException;
import org.gatein.wci.authentication.AuthenticationListener;
import org.gatein.wci.security.Credentials;

public class LoginServlet
extends AbstractHttpServlet {
    private static final long serialVersionUID = -1330051083735349589L;
    private static final int UNAUTHENTICATED = 0;
    private static final int AUTHENTICATED = 1;
    private static final int FAILED = 2;
    private static final Logger log = LoggerFactory.getLogger(LoginServlet.class);
    public static final String COOKIE_NAME = "rememberme";

    protected void afterInit(ServletConfig config) throws ServletException {
        ServletContainerFactory.getServletContainer().addAuthenticationListener(new AuthenticationListener(){

            public void onEvent(AuthenticationEvent event) {
                if (event.getType() == AuthenticationEventType.LOGIN) {
                    LoginServlet.bindCredentialsToAuthenticationRegistry(LoginServlet.this.getContainer(), event.getRequest(), event.getCredentials());
                }
            }
        });
    }

    public static String getRememberMeTokenCookie(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!COOKIE_NAME.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        int status;
        req.setCharacterEncoding("UTF-8");
        String username = req.getParameter("username");
        String password = req.getParameter("password");
        if (req.getRemoteUser() == null) {
            if (username != null && password != null) {
                Credentials credentials;
                block18: {
                    credentials = new Credentials(username, password);
                    ServletContainer container = ServletContainerFactory.getServletContainer();
                    try {
                        container.login(req, resp, credentials);
                    }
                    catch (AuthenticationException e) {
                        log.debug((Object)"User authentication failed");
                        if (!log.isTraceEnabled()) break block18;
                        log.trace((Object)e.getMessage(), (Throwable)e);
                    }
                }
                int n = status = req.getRemoteUser() != null ? 1 : 2;
                if (status == 1) {
                    String rememberme;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"User authenticated successfuly through WCI. Will redirect to initialURI");
                    }
                    if ("true".equals(rememberme = req.getParameter(COOKIE_NAME))) {
                        CookieTokenService tokenService = AbstractTokenService.getInstance(CookieTokenService.class);
                        String cookieToken = tokenService.createToken(credentials);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Found a remember me request parameter, created a persistent token " + cookieToken + " for it and set it up " + "in the next response"));
                        }
                        Cookie cookie = new Cookie(COOKIE_NAME, cookieToken);
                        cookie.setPath(req.getContextPath());
                        cookie.setMaxAge((int)tokenService.getValidityTime());
                        resp.addCookie(cookie);
                    }
                }
            } else {
                log.debug((Object)"username or password not provided. Changing status to UNAUTHENTICATED");
                status = 0;
            }
        } else {
            log.debug((Object)"User already authenticated. Will redirect to initialURI");
            status = 1;
        }
        String uri = req.getParameter("initialURI");
        if (uri == null || uri.length() == 0) {
            uri = req.getContextPath();
            log.debug((Object)("No initial URI found, will use default " + uri + " instead "));
        } else {
            log.debug((Object)("Found initial URI " + uri));
        }
        if (status == 1) {
            resp.sendRedirect(resp.encodeRedirectURL(uri));
        } else {
            if (status == 2) {
                req.setAttribute("org.gatein.portal.login.error", (Object)"whatever");
            }
            req.setAttribute("org.gatein.portal.login.initial_uri", (Object)uri);
            SSOHelper ssoHelper = (SSOHelper)this.getContainer().getComponentInstanceOfType(SSOHelper.class);
            if (ssoHelper.skipJSPRedirection()) {
                String ssoRedirectUrl = req.getContextPath() + ssoHelper.getSSORedirectURLSuffix();
                ssoRedirectUrl = resp.encodeRedirectURL(ssoRedirectUrl);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Redirected to SSO login URL: " + ssoRedirectUrl));
                }
                resp.sendRedirect(ssoRedirectUrl);
            } else {
                resp.setContentType("text/html; charset=UTF-8");
                this.getServletContext().getRequestDispatcher("/login/jsp/login.jsp").include((ServletRequest)req, (ServletResponse)resp);
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private static void bindCredentialsToAuthenticationRegistry(ExoContainer exoContainer, HttpServletRequest req, Credentials credentials) {
        AuthenticationRegistry authRegistry = (AuthenticationRegistry)exoContainer.getComponentInstanceOfType(AuthenticationRegistry.class);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Binding credentials to temporary authentication registry for user " + credentials.getUsername()));
        }
        authRegistry.setCredentials(req, credentials);
    }
}

