/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.web.login.LoginServlet;
import org.exoplatform.web.security.AuthenticationRegistry;
import org.exoplatform.web.security.security.CookieTokenService;
import org.gatein.wci.ServletContainer;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.security.Credentials;

public class RememberMeFilter
extends AbstractFilter {
    public static final String ATTRIBUTE_AUTHENTICATED_PORTAL_USER_FOR_JAAS = "_authenticatedPortalUserForJaas";

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)req, (HttpServletResponse)resp, chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFilter(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        String disabledUser;
        ExoContainer container;
        Credentials credentials;
        String token;
        if (req.getRemoteUser() == null) {
            CookieTokenService tokenservice;
            token = LoginServlet.getRememberMeTokenCookie(req);
            if (token != null && (credentials = (tokenservice = (CookieTokenService)(container = this.getContainer()).getComponentInstanceOfType(CookieTokenService.class)).validateToken(token, false)) != null) {
                ServletContainer servletContainer = ServletContainerFactory.getServletContainer();
                try {
                    servletContainer.login(req, resp, credentials);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (req.getRemoteUser() == null) {
                Cookie cookie = new Cookie("rememberme", "");
                cookie.setPath(req.getContextPath());
                cookie.setMaxAge(0);
                resp.addCookie(cookie);
            }
        }
        if (req.getRemoteUser() == null && (token = LoginServlet.getOauthRememberMeTokenCookie(req)) != null) {
            container = this.getContainer();
            CookieTokenService tokenService = (CookieTokenService)container.getComponentInstanceOfType(CookieTokenService.class);
            credentials = tokenService.validateToken(token, false);
            AuthenticationRegistry authRegistry = (AuthenticationRegistry)container.getComponentInstanceOfType(AuthenticationRegistry.class);
            OrganizationService orgService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
            if (credentials != null) {
                ServletContainer servletContainer = ServletContainerFactory.getServletContainer();
                try {
                    String username = credentials.getUsername();
                    this.begin(orgService);
                    User portalUser = orgService.getUserHandler().findUserByName(username, UserStatus.ENABLED);
                    if (portalUser != null) {
                        authRegistry.setAttributeOfClient(req, ATTRIBUTE_AUTHENTICATED_PORTAL_USER_FOR_JAAS, portalUser);
                        servletContainer.login(req, resp, credentials);
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    this.end(orgService);
                }
            }
            if (req.getRemoteUser() == null) {
                Cookie cookie = new Cookie("oauth_rememberme", "");
                cookie.setPath(req.getContextPath());
                cookie.setMaxAge(0);
                resp.addCookie(cookie);
            }
        }
        if (req.getRemoteUser() == null && (disabledUser = (String)req.getAttribute("_disabledUserName")) != null) {
            req.getRequestDispatcher("/login").forward((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
    }

    public void destroy() {
    }

    public void begin(OrganizationService orgService) {
        if (orgService instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.begin((ComponentRequestLifecycle)((ComponentRequestLifecycle)orgService));
        }
    }

    public void end(OrganizationService orgService) {
        if (orgService instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.end();
        }
    }
}

