/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.codec;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.web.security.codec.AbstractCodec;
import org.exoplatform.web.security.codec.AbstractCodecBuilder;
import org.exoplatform.web.security.security.TokenServiceInitializationException;
import org.gatein.common.io.IOTools;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class CodecInitializer {
    private final Logger log = LoggerFactory.getLogger(CodecInitializer.class);
    private final String confDir;
    private volatile AbstractCodec codec;

    public CodecInitializer(InitParams initParams) {
        ValueParam gateinConfParam = initParams.getValueParam("gatein.conf.dir");
        this.confDir = gateinConfParam != null ? gateinConfParam.getValue() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractCodec getCodec() throws TokenServiceInitializationException {
        AbstractCodec helper = this.codec;
        if (helper == null) {
            CodecInitializer codecInitializer = this;
            synchronized (codecInitializer) {
                helper = this.codec;
                if (helper == null) {
                    this.codec = helper = this.initCodec();
                }
            }
        }
        return helper;
    }

    protected AbstractCodec initCodec() throws TokenServiceInitializationException {
        HashMap<String, String> config;
        String builderType;
        block19: {
            block18: {
                builderType = PropertyManager.getProperty((String)"gatein.codec.builderclass");
                config = new HashMap<String, String>();
                if (builderType == null) break block18;
                String configFile = PropertyManager.getProperty((String)"gatein.codec.config");
                FileInputStream in = null;
                try {
                    File f = new File(configFile);
                    in = new FileInputStream(f);
                    Properties properties = new Properties();
                    properties.load(in);
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        config.put((String)entry.getKey(), (String)entry.getValue());
                    }
                    config.put("gatein.codec.config.basedir", f.getParentFile().getAbsolutePath());
                }
                catch (IOException e) {
                    try {
                        throw new TokenServiceInitializationException("Failed to read the config parameters from file '" + configFile + "'.", e);
                    }
                    catch (Throwable throwable) {
                        IOTools.safeClose(in);
                        throw throwable;
                    }
                }
                IOTools.safeClose((Closeable)in);
                break block19;
            }
            builderType = "org.exoplatform.web.security.codec.JCASymmetricCodecBuilder";
            String gtnConfDir = null;
            if (this.confDir != null) {
                ConfigurationManager confManager = (ConfigurationManager)RootContainer.getInstance().getComponentInstanceOfType(ConfigurationManager.class);
                try {
                    gtnConfDir = confManager.getResource(this.confDir).getPath();
                }
                catch (Exception ex) {
                    this.log.error((Object)"Failed to process the path to gateinConfDir", (Throwable)ex);
                }
            }
            if (gtnConfDir == null && ((gtnConfDir = PropertyManager.getProperty((String)"gatein.conf.dir")) == null || gtnConfDir.length() == 0)) {
                throw new TokenServiceInitializationException("'gatein.conf.dir' property must be set.");
            }
            File f = new File(gtnConfDir + "/codec/codeckey.txt");
            if (!f.exists()) {
                File codecDir = f.getParentFile();
                if (!codecDir.exists()) {
                    codecDir.mkdir();
                }
                FileOutputStream out = null;
                try {
                    KeyGenerator keyGen = KeyGenerator.getInstance("AES");
                    keyGen.init(128);
                    SecretKey key = keyGen.generateKey();
                    KeyStore store = KeyStore.getInstance("JCEKS");
                    store.load(null, "gtnStorePass".toCharArray());
                    store.setEntry("gtnKey", new KeyStore.SecretKeyEntry(key), new KeyStore.PasswordProtection("gtnKeyPass".toCharArray()));
                    out = new FileOutputStream(f);
                    store.store(out, "gtnStorePass".toCharArray());
                }
                catch (Exception e) {
                    try {
                        throw new TokenServiceInitializationException(e);
                    }
                    catch (Throwable throwable) {
                        IOTools.safeClose(out);
                        throw throwable;
                    }
                }
                IOTools.safeClose((Closeable)out);
            }
            config.put("gatein.codec.jca.symmetric.keyalg", "AES");
            config.put("gatein.codec.jca.symmetric.keystore", "codeckey.txt");
            config.put("gatein.codec.jca.symmetric.storetype", "JCEKS");
            config.put("gatein.codec.jca.symmetric.alias", "gtnKey");
            config.put("gatein.codec.jca.symmetric.keypass", "gtnKeyPass");
            config.put("gatein.codec.jca.symmetric.storepass", "gtnStorePass");
            config.put("gatein.codec.config.basedir", f.getParentFile().getAbsolutePath());
        }
        try {
            this.log.info((Object)("Initialized codec using builder " + builderType));
            return Class.forName(builderType).asSubclass(AbstractCodecBuilder.class).newInstance().build(config);
        }
        catch (Exception e) {
            throw new TokenServiceInitializationException("Could not initialize codec.", e);
        }
    }
}

