/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.webservices.WSMessages;
import org.jboss.as.webservices.dmr.PackageUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.metadata.config.EndpointConfig;

final class PropertyAdd
extends AbstractAddStepHandler {
    static final PropertyAdd INSTANCE = new PropertyAdd();

    private PropertyAdd() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServerConfig config = PackageUtils.getServerConfig(context);
        if (config != null) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String propertyName = address.getElement(address.size() - 1).getValue();
            String configName = address.getElement(address.size() - 2).getValue();
            String propertyValue = operation.has("value") ? operation.get("value").asString() : null;
            for (EndpointConfig endpointConfig : config.getEndpointConfigs()) {
                if (!configName.equals(endpointConfig.getConfigName())) continue;
                endpointConfig.setProperty(propertyName, propertyValue);
                if (!context.isBooting()) {
                    context.restartRequired();
                }
                return;
            }
            throw WSMessages.MESSAGES.missingEndpointConfig(configName);
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        if (operation.hasDefined("value")) {
            ModelNode propertyValue = operation.get("value");
            model.get("value").set(propertyValue);
        }
    }
}

