/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.publish;

import java.util.Map;
import org.jboss.as.controller.PathElement;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.SimpleAttachable;
import org.jboss.as.webservices.metadata.model.JAXWSDeployment;
import org.jboss.as.webservices.metadata.model.POJOEndpoint;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.dmr.ModelNode;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;

public class WSEndpointDeploymentUnit
extends SimpleAttachable
implements DeploymentUnit {
    private String deploymentName;

    public WSEndpointDeploymentUnit(ClassLoader loader, String context, Map<String, String> urlPatternToClassName, WebservicesMetaData metadata) {
        this.deploymentName = context + ".deployment";
        JBossWebMetaData jbossWebMetaData = new JBossWebMetaData();
        JAXWSDeployment jaxwsDeployment = new JAXWSDeployment();
        jbossWebMetaData.setContextRoot(context);
        for (String urlPattern : urlPatternToClassName.keySet()) {
            this.addEndpoint(jbossWebMetaData, jaxwsDeployment, urlPatternToClassName.get(urlPattern), urlPattern);
        }
        this.putAttachment(WSAttachmentKeys.CLASSLOADER_KEY, loader);
        this.putAttachment(WSAttachmentKeys.JAXWS_ENDPOINTS_KEY, jaxwsDeployment);
        this.putAttachment(WSAttachmentKeys.JBOSSWEB_METADATA_KEY, jbossWebMetaData);
        this.putAttachment(WSAttachmentKeys.WEBSERVICES_METADATA_KEY, metadata);
    }

    private void addEndpoint(JBossWebMetaData jbossWebMetaData, JAXWSDeployment jaxwsDeployment, String className, String urlPattern) {
        if (urlPattern == null) {
            urlPattern = "/*";
        } else if (!(urlPattern = urlPattern.trim()).startsWith("/")) {
            urlPattern = "/" + urlPattern;
        }
        jaxwsDeployment.addEndpoint(new POJOEndpoint(className, urlPattern));
    }

    public ServiceName getServiceName() {
        return ServiceName.JBOSS.append(new String[]{"ws-endpoint-deployment"}).append(new String[]{this.deploymentName});
    }

    public DeploymentUnit getParent() {
        return null;
    }

    public String getName() {
        return this.deploymentName;
    }

    public ServiceRegistry getServiceRegistry() {
        return WSServices.getContainerRegistry();
    }

    public ModelNode getDeploymentSubsystemModel(String subsystemName) {
        throw new UnsupportedOperationException();
    }

    public ModelNode createDeploymentSubModel(String subsystemName, PathElement address) {
        throw new UnsupportedOperationException();
    }
}

