/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.webserviceref;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.jws.HandlerChain;
import javax.xml.namespace.QName;
import javax.xml.ws.RespectBinding;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.WebServiceRefs;
import javax.xml.ws.soap.MTOM;
import org.jboss.as.webservices.WSLogger;
import org.jboss.metadata.javaee.jboss.JBossPortComponentRef;
import org.jboss.metadata.javaee.jboss.JBossServiceReferenceMetaData;
import org.jboss.metadata.javaee.jboss.StubPropertyMetaData;
import org.jboss.metadata.javaee.spec.Addressing;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.spec.PortComponentRef;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerChainMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerChainsMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlersMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedInitParamMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedStubPropertyMetaData;
import org.jboss.wsf.spi.serviceref.ServiceRefHandler;

final class WSRefUtils {
    private WSRefUtils() {
    }

    static UnifiedServiceRefMetaData translate(ServiceReferenceMetaData serviceRefMD, UnifiedServiceRefMetaData serviceRefUMDM) {
        ServiceReferenceHandlerChainsMetaData handlerChainsMD;
        ServiceReferenceHandlersMetaData handlersMD;
        serviceRefUMDM.setServiceRefName(serviceRefMD.getName());
        serviceRefUMDM.setServiceRefType(serviceRefMD.getServiceRefType());
        serviceRefUMDM.setServiceInterface(serviceRefMD.getServiceInterface());
        serviceRefUMDM.setWsdlFile(serviceRefMD.getWsdlFile());
        serviceRefUMDM.setMappingFile(serviceRefMD.getJaxrpcMappingFile());
        serviceRefUMDM.setServiceQName(serviceRefMD.getServiceQname());
        List portComponentsMD = serviceRefMD.getPortComponentRef();
        if (portComponentsMD != null) {
            for (PortComponentRef portComponentMD : portComponentsMD) {
                UnifiedPortComponentRefMetaData portComponentUMDM = WSRefUtils.getUnifiedPortComponentRefMetaData(serviceRefUMDM, portComponentMD);
                if (portComponentUMDM.getServiceEndpointInterface() != null || portComponentUMDM.getPortQName() != null) {
                    serviceRefUMDM.addPortComponentRef(portComponentUMDM);
                    continue;
                }
                WSLogger.ROOT_LOGGER.ignoringPortComponentRef(portComponentUMDM);
            }
        }
        if ((handlersMD = serviceRefMD.getHandlers()) != null) {
            for (ServiceReferenceHandlerMetaData handlerMD : handlersMD) {
                UnifiedHandlerMetaData handlerUMDM = WSRefUtils.getUnifiedHandlerMetaData(handlerMD);
                serviceRefUMDM.addHandler(handlerUMDM);
            }
        }
        if ((handlerChainsMD = serviceRefMD.getHandlerChains()) != null) {
            UnifiedHandlerChainsMetaData handlerChainsUMDM = WSRefUtils.getUnifiedHandlerChainsMetaData(handlerChainsMD);
            serviceRefUMDM.setHandlerChains(handlerChainsUMDM);
        }
        if (serviceRefMD instanceof JBossServiceReferenceMetaData) {
            WSRefUtils.processUnifiedJBossServiceRefMetaData(serviceRefUMDM, serviceRefMD);
        }
        WSRefUtils.processType(serviceRefUMDM);
        return serviceRefUMDM;
    }

    private static void processUnifiedJBossServiceRefMetaData(UnifiedServiceRefMetaData serviceRefUMDM, ServiceReferenceMetaData serviceRefMD) {
        JBossServiceReferenceMetaData jbossServiceRefMD = (JBossServiceReferenceMetaData)serviceRefMD;
        serviceRefUMDM.setServiceImplClass(jbossServiceRefMD.getServiceClass());
        serviceRefUMDM.setConfigName(jbossServiceRefMD.getConfigName());
        serviceRefUMDM.setConfigFile(jbossServiceRefMD.getConfigFile());
        serviceRefUMDM.setWsdlOverride(jbossServiceRefMD.getWsdlOverride());
        serviceRefUMDM.setHandlerChain(jbossServiceRefMD.getHandlerChain());
    }

    private static UnifiedPortComponentRefMetaData getUnifiedPortComponentRefMetaData(UnifiedServiceRefMetaData serviceRefUMDM, PortComponentRef portComponentMD) {
        UnifiedPortComponentRefMetaData portComponentUMDM = new UnifiedPortComponentRefMetaData(serviceRefUMDM);
        portComponentUMDM.setServiceEndpointInterface(portComponentMD.getServiceEndpointInterface());
        portComponentUMDM.setMtomEnabled(portComponentMD.isEnableMtom());
        portComponentUMDM.setMtomThreshold(portComponentMD.getMtomThreshold());
        Addressing addressingMD = portComponentMD.getAddressing();
        if (addressingMD != null) {
            portComponentUMDM.setAddressingAnnotationSpecified(true);
            portComponentUMDM.setAddressingEnabled(addressingMD.isEnabled());
            portComponentUMDM.setAddressingRequired(addressingMD.isRequired());
            portComponentUMDM.setAddressingResponses(addressingMD.getResponses());
        }
        if (portComponentMD.getRespectBinding() != null) {
            portComponentUMDM.setRespectBindingAnnotationSpecified(true);
            portComponentUMDM.setRespectBindingEnabled(true);
        }
        portComponentUMDM.setPortComponentLink(portComponentMD.getPortComponentLink());
        if (portComponentMD instanceof JBossPortComponentRef) {
            WSRefUtils.processUnifiedJBossPortComponentRefMetaData(portComponentUMDM, portComponentMD);
        }
        return portComponentUMDM;
    }

    private static void processUnifiedJBossPortComponentRefMetaData(UnifiedPortComponentRefMetaData portComponentUMDM, PortComponentRef portComponentMD) {
        JBossPortComponentRef jbossPortComponentMD = (JBossPortComponentRef)portComponentMD;
        portComponentUMDM.setPortQName(jbossPortComponentMD.getPortQname());
        portComponentUMDM.setConfigName(jbossPortComponentMD.getConfigName());
        portComponentUMDM.setConfigFile(jbossPortComponentMD.getConfigFile());
        List stubPropertiesMD = jbossPortComponentMD.getStubProperties();
        if (stubPropertiesMD != null) {
            for (StubPropertyMetaData stubPropertyMD : stubPropertiesMD) {
                UnifiedStubPropertyMetaData stubPropertyUMDM = new UnifiedStubPropertyMetaData();
                stubPropertyUMDM.setPropName(stubPropertyMD.getPropName());
                stubPropertyUMDM.setPropValue(stubPropertyMD.getPropValue());
                portComponentUMDM.addStubProperty(stubPropertyUMDM);
            }
        }
    }

    private static UnifiedHandlerMetaData getUnifiedHandlerMetaData(ServiceReferenceHandlerMetaData srhmd) {
        List portNames;
        List soapRoles;
        List soapHeaders;
        UnifiedHandlerMetaData handlerUMDM = new UnifiedHandlerMetaData();
        handlerUMDM.setHandlerName(srhmd.getHandlerName());
        handlerUMDM.setHandlerClass(srhmd.getHandlerClass());
        List initParams = srhmd.getInitParam();
        if (initParams != null) {
            for (ParamValueMetaData initParam : initParams) {
                UnifiedInitParamMetaData param = new UnifiedInitParamMetaData();
                param.setParamName(initParam.getParamName());
                param.setParamValue(initParam.getParamValue());
                handlerUMDM.addInitParam(param);
            }
        }
        if ((soapHeaders = srhmd.getSoapHeader()) != null) {
            for (QName soapHeader : soapHeaders) {
                handlerUMDM.addSoapHeader(soapHeader);
            }
        }
        if ((soapRoles = srhmd.getSoapRole()) != null) {
            for (String soapRole : soapRoles) {
                handlerUMDM.addSoapRole(soapRole);
            }
        }
        if ((portNames = srhmd.getPortName()) != null) {
            for (String portName : portNames) {
                handlerUMDM.addPortName(portName);
            }
        }
        return handlerUMDM;
    }

    private static UnifiedHandlerChainsMetaData getUnifiedHandlerChainsMetaData(ServiceReferenceHandlerChainsMetaData handlerChainsMD) {
        UnifiedHandlerChainsMetaData handlerChainsUMDM = new UnifiedHandlerChainsMetaData();
        for (ServiceReferenceHandlerChainMetaData handlerChainMD : handlerChainsMD.getHandlers()) {
            UnifiedHandlerChainMetaData handlerChainUMDM = new UnifiedHandlerChainMetaData();
            handlerChainUMDM.setServiceNamePattern(handlerChainMD.getServiceNamePattern());
            handlerChainUMDM.setPortNamePattern(handlerChainMD.getPortNamePattern());
            handlerChainUMDM.setProtocolBindings(handlerChainMD.getProtocolBindings());
            for (ServiceReferenceHandlerMetaData handlerMD : handlerChainMD.getHandler()) {
                UnifiedHandlerMetaData handlerUMDM = WSRefUtils.getUnifiedHandlerMetaData(handlerMD);
                handlerChainUMDM.addHandler(handlerUMDM);
            }
            handlerChainsUMDM.addHandlerChain(handlerChainUMDM);
        }
        return handlerChainsUMDM;
    }

    static void processType(UnifiedServiceRefMetaData serviceRefUMDM) {
        boolean isJAXRPC = serviceRefUMDM.getMappingFile() != null || "javax.xml.rpc.Service".equals(serviceRefUMDM.getServiceInterface());
        serviceRefUMDM.setType(isJAXRPC ? ServiceRefHandler.Type.JAXRPC : ServiceRefHandler.Type.JAXWS);
    }

    static void processAnnotatedElement(AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRefUMDM) {
        WSRefUtils.processAddressingAnnotation(anElement, serviceRefUMDM);
        WSRefUtils.processMTOMAnnotation(anElement, serviceRefUMDM);
        WSRefUtils.processRespectBindingAnnotation(anElement, serviceRefUMDM);
        WSRefUtils.processHandlerChainAnnotation(anElement, serviceRefUMDM);
        WSRefUtils.processServiceRefType(anElement, serviceRefUMDM);
    }

    private static void processAddressingAnnotation(AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRefUMDM) {
        javax.xml.ws.soap.Addressing addressingAnnotation = WSRefUtils.getAnnotation(anElement, javax.xml.ws.soap.Addressing.class);
        if (addressingAnnotation != null) {
            serviceRefUMDM.setAddressingAnnotationSpecified(true);
            serviceRefUMDM.setAddressingEnabled(addressingAnnotation.enabled());
            serviceRefUMDM.setAddressingRequired(addressingAnnotation.required());
            serviceRefUMDM.setAddressingResponses(addressingAnnotation.responses().toString());
        }
    }

    private static void processMTOMAnnotation(AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRefUMDM) {
        MTOM mtomAnnotation = WSRefUtils.getAnnotation(anElement, MTOM.class);
        if (mtomAnnotation != null) {
            serviceRefUMDM.setMtomAnnotationSpecified(true);
            serviceRefUMDM.setMtomEnabled(mtomAnnotation.enabled());
            serviceRefUMDM.setMtomThreshold(mtomAnnotation.threshold());
        }
    }

    private static void processRespectBindingAnnotation(AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRefUMDM) {
        RespectBinding respectBindingAnnotation = WSRefUtils.getAnnotation(anElement, RespectBinding.class);
        if (respectBindingAnnotation != null) {
            serviceRefUMDM.setRespectBindingAnnotationSpecified(true);
            serviceRefUMDM.setRespectBindingEnabled(respectBindingAnnotation.enabled());
        }
    }

    private static void processServiceRefType(AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRefUMDM) {
        if (anElement instanceof Field) {
            Class<?> targetClass = ((Field)anElement).getType();
            serviceRefUMDM.setServiceRefType(targetClass.getName());
            if (Service.class.isAssignableFrom(targetClass)) {
                serviceRefUMDM.setServiceInterface(targetClass.getName());
            }
        } else if (anElement instanceof Method) {
            Class<?> targetClass = ((Method)anElement).getParameterTypes()[0];
            serviceRefUMDM.setServiceRefType(targetClass.getName());
            if (Service.class.isAssignableFrom(targetClass)) {
                serviceRefUMDM.setServiceInterface(targetClass.getName());
            }
        } else {
            WebServiceRef serviceRefAnnotation = WSRefUtils.getWebServiceRefAnnotation(anElement, serviceRefUMDM);
            Class targetClass = null;
            if (serviceRefAnnotation != null && serviceRefAnnotation.type() != Object.class) {
                targetClass = serviceRefAnnotation.type();
                serviceRefUMDM.setServiceRefType(targetClass.getName());
                if (Service.class.isAssignableFrom(targetClass)) {
                    serviceRefUMDM.setServiceInterface(targetClass.getName());
                }
            }
        }
    }

    private static void processHandlerChainAnnotation(AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRefUMDM) {
        HandlerChain handlerChainAnnotation = WSRefUtils.getAnnotation(anElement, HandlerChain.class);
        if (handlerChainAnnotation != null) {
            String handlerChain = null;
            if (handlerChainAnnotation.file().length() > 0) {
                handlerChain = handlerChainAnnotation.file();
            }
            if (handlerChain != null) {
                try {
                    new URL(handlerChain);
                }
                catch (MalformedURLException ignored) {
                    Class<?> declaringClass = WSRefUtils.getDeclaringClass(anElement);
                    handlerChain = declaringClass.getPackage().getName().replace('.', '/') + "/" + handlerChain;
                }
                serviceRefUMDM.setHandlerChain(handlerChain);
            }
        }
    }

    private static <T extends Annotation> T getAnnotation(AnnotatedElement anElement, Class<T> annotationClass) {
        return anElement != null ? (T)anElement.getAnnotation(annotationClass) : null;
    }

    private static Class<?> getDeclaringClass(AnnotatedElement annotatedElement) {
        Class declaringClass = null;
        if (annotatedElement instanceof Field) {
            declaringClass = ((Field)annotatedElement).getDeclaringClass();
        } else if (annotatedElement instanceof Method) {
            declaringClass = ((Method)annotatedElement).getDeclaringClass();
        } else if (annotatedElement instanceof Class) {
            declaringClass = (Class)annotatedElement;
        }
        return declaringClass;
    }

    private static WebServiceRef getWebServiceRefAnnotation(AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRefUMDM) {
        WebServiceRef webServiceRefAnnotation = WSRefUtils.getAnnotation(anElement, WebServiceRef.class);
        WebServiceRefs webServiceRefsAnnotation = WSRefUtils.getAnnotation(anElement, WebServiceRefs.class);
        if (webServiceRefAnnotation == null && webServiceRefsAnnotation == null) {
            return null;
        }
        ArrayList<WebServiceRef> wsrefList = new ArrayList<WebServiceRef>();
        if (webServiceRefAnnotation != null) {
            wsrefList.add(webServiceRefAnnotation);
        }
        if (webServiceRefsAnnotation != null) {
            for (WebServiceRef webServiceRefAnn : webServiceRefsAnnotation.value()) {
                wsrefList.add(webServiceRefAnn);
            }
        }
        WebServiceRef returnValue = null;
        if (wsrefList.size() == 1) {
            returnValue = (WebServiceRef)wsrefList.get(0);
        } else {
            for (WebServiceRef webServiceRefAnn : wsrefList) {
                if (!serviceRefUMDM.getServiceRefName().endsWith(webServiceRefAnn.name())) continue;
                returnValue = webServiceRefAnn;
                break;
            }
        }
        return returnValue;
    }
}

