/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.InputFilter;
import org.apache.tomcat.util.buf.ByteChunk;

public class IdentityInputFilter
implements InputFilter {
    protected static final String ENCODING_NAME = "identity";
    protected static final ByteChunk ENCODING = new ByteChunk();
    protected long contentLength = -1L;
    protected long remaining = 0L;
    protected InputBuffer buffer;
    protected ByteChunk endChunk = new ByteChunk();

    public long getContentLength() {
        return this.contentLength;
    }

    public long getRemaining() {
        return this.remaining;
    }

    @Override
    public int doRead(ByteChunk chunk, Request req) throws IOException {
        int result = -1;
        if (this.contentLength >= 0L) {
            if (this.remaining > 0L) {
                int nRead = this.buffer.doRead(chunk, req);
                if ((long)nRead > this.remaining) {
                    chunk.setBytes(chunk.getBytes(), chunk.getStart(), (int)this.remaining);
                    result = (int)this.remaining;
                } else {
                    result = nRead;
                }
                this.remaining -= (long)nRead;
            } else {
                chunk.recycle();
                result = -1;
            }
        }
        return result;
    }

    @Override
    public void setRequest(Request request) {
        this.remaining = this.contentLength = request.getContentLengthLong();
    }

    @Override
    public long end() throws IOException {
        while (this.remaining > 0L) {
            int nread = this.buffer.doRead(this.endChunk, null);
            if (nread > 0) {
                this.remaining -= (long)nread;
                continue;
            }
            this.remaining = 0L;
        }
        return -this.remaining;
    }

    @Override
    public int available() {
        return 0;
    }

    @Override
    public void setBuffer(InputBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void recycle() {
        this.contentLength = -1L;
        this.remaining = 0L;
        this.endChunk.recycle();
    }

    @Override
    public ByteChunk getEncodingName() {
        return ENCODING;
    }

    static {
        ENCODING.setBytes(ENCODING_NAME.getBytes(), 0, ENCODING_NAME.length());
    }
}

