/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.injection;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.ws.common.deployment.ReferenceFactory;
import org.jboss.ws.common.integration.AbstractDeploymentAspect;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.InstanceProvider;
import org.jboss.wsf.spi.deployment.Reference;

public final class InjectionDeploymentAspect
extends AbstractDeploymentAspect {
    public void start(Deployment dep) {
        if (WSHelper.isJaxrpcDeployment((Deployment)dep)) {
            return;
        }
        for (Endpoint ep : dep.getService().getEndpoints()) {
            this.setInjectionAwareInstanceProvider(ep);
        }
    }

    private void setInjectionAwareInstanceProvider(Endpoint ep) {
        InstanceProvider stackInstanceProvider = ep.getInstanceProvider();
        DeploymentUnit unit = (DeploymentUnit)ep.getService().getDeployment().getAttachment(DeploymentUnit.class);
        InjectionAwareInstanceProvider injectionAwareInstanceProvider = new InjectionAwareInstanceProvider(stackInstanceProvider, ep, unit);
        ep.setInstanceProvider((InstanceProvider)injectionAwareInstanceProvider);
    }

    private static final class InjectionAwareInstanceProvider
    implements InstanceProvider {
        private final InstanceProvider delegate;
        private final String endpointName;
        private final String endpointClass;
        private final boolean isEjb3Endpoint;
        private final ServiceName componentPrefix;
        private static final String componentSuffix = "START";
        private final Map<String, Reference> cache = new HashMap<String, Reference>();

        private InjectionAwareInstanceProvider(InstanceProvider delegate, Endpoint endpoint, DeploymentUnit unit) {
            this.delegate = delegate;
            this.endpointName = endpoint.getShortName();
            this.endpointClass = endpoint.getTargetBeanName();
            this.isEjb3Endpoint = WSHelper.isEjbEndpoint((Endpoint)endpoint);
            this.componentPrefix = unit.getServiceName().append(new String[]{"component"});
        }

        public synchronized Reference getInstance(String className) {
            Reference instance = this.cache.get(className);
            if (instance != null) {
                return instance;
            }
            if (className.equals(this.endpointClass)) {
                ServiceName endpointComponentName;
                ServiceController<BasicComponent> endpointController;
                if (!this.isEjb3Endpoint && (endpointController = InjectionAwareInstanceProvider.getComponentController(endpointComponentName = this.getEndpointComponentServiceName())) != null) {
                    BasicComponent endpointComponent = (BasicComponent)endpointController.getValue();
                    ComponentInstance endpointComponentInstance = endpointComponent.createInstance(this.delegate.getInstance(className).getValue());
                    Object endpointInstance = endpointComponentInstance.getInstance();
                    Reference endpointReference = ReferenceFactory.newInitializedReference((Object)endpointInstance);
                    return this.cacheAndGet(endpointReference);
                }
            } else {
                ServiceName handlerComponentName = this.getHandlerComponentServiceName(className);
                ServiceController<BasicComponent> handlerComponentController = InjectionAwareInstanceProvider.getComponentController(handlerComponentName);
                if (handlerComponentController != null) {
                    BasicComponent handlerComponent = (BasicComponent)handlerComponentController.getValue();
                    ComponentInstance handlerComponentInstance = handlerComponent.createInstance(this.delegate.getInstance(className).getValue());
                    Object handlerInstance = handlerComponentInstance.getInstance();
                    Reference handlerReference = ReferenceFactory.newInitializedReference((Object)handlerInstance);
                    return this.cacheAndGet(handlerReference);
                }
            }
            Reference fallbackInstance = this.delegate.getInstance(className);
            Reference fallbackReference = ReferenceFactory.newUninitializedReference((Reference)fallbackInstance);
            return this.cacheAndGet(fallbackReference);
        }

        private Reference cacheAndGet(Reference instance) {
            this.cache.put(instance.getValue().getClass().getName(), instance);
            return instance;
        }

        private ServiceName getEndpointComponentServiceName() {
            return this.componentPrefix.append(new String[]{this.endpointName}).append(new String[]{componentSuffix});
        }

        private ServiceName getHandlerComponentServiceName(String handlerClassName) {
            return this.componentPrefix.append(new String[]{this.endpointName + "-" + handlerClassName}).append(new String[]{componentSuffix});
        }

        private static ServiceController<BasicComponent> getComponentController(ServiceName componentName) {
            return WSServices.getContainerRegistry().getService(componentName);
        }
    }
}

