/*
 * Copyright (C) 2010 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.exoplatform.portal.pom.config.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;


/**
 * A serializable object that is a private marker representing a null value.
 *
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class NullObject implements Serializable {

    /** VM singleton. */
    private static final NullObject instance = new NullObject();

    public static NullObject get() {
        return instance;
    }

    private Object readResolve() throws ObjectStreamException {
        return instance;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        // Nothing to do
    }

    private void readObject(ObjectInputStream in) throws IOException {
        // Nothing to do
    }

    @Override
    public String toString() {
        return "NullObject[]";
    }
}
