/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.jboss.as7.deployment.wsrp;

import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarFile;
import org.gatein.integration.jboss.as7.deployment.GateInExtKey;
import org.gatein.integration.jboss.as7.deployment.wsrp.GateInWSRPKey;
import org.gatein.integration.jboss.as7.deployment.wsrp.WSRPPostModuleDeploymentProcessor;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;
import org.jboss.vfs.VirtualFile;

public class WSRPStructureDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final Logger log = Logger.getLogger(WSRPStructureDeploymentProcessor.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        String name;
        DeploymentUnit du = phaseContext.getDeploymentUnit();
        if (this.isWSRPPlugin(du)) {
            du.putAttachment(GateInWSRPKey.KEY, (Object)GateInWSRPKey.INSTANCE);
            ModuleSpecification moduleSpecification = (ModuleSpecification)du.getAttachment(Attachments.MODULE_SPECIFICATION);
            ModuleLoader moduleLoader = Module.getBootModuleLoader();
            ModuleDependency dependency = new ModuleDependency(moduleLoader, ModuleIdentifier.fromString((String)"org.gatein.wsrp"), false, false, false, false);
            moduleSpecification.addSystemDependency(dependency);
            dependency = new ModuleDependency(moduleLoader, ModuleIdentifier.fromString((String)"org.gatein.pc"), false, false, false, false);
            moduleSpecification.addSystemDependency(dependency);
            dependency = new ModuleDependency(moduleLoader, ModuleIdentifier.fromString((String)"org.apache.ws.security"), false, false, false, false);
            moduleSpecification.addSystemDependency(dependency);
            log.infof("Adding WSRP, PC & Apache WS Security  dependencies to %s", (Object)du.getName());
        }
        if ((name = du.getName()).contains("wsrp-admin-gui") || name.contains("extension-war")) {
            ModuleSpecification moduleSpecification = (ModuleSpecification)du.getAttachment(Attachments.MODULE_SPECIFICATION);
            ModuleLoader moduleLoader = Module.getBootModuleLoader();
            try {
                Module module = moduleLoader.loadModule(ModuleIdentifier.fromString((String)"org.gatein.wsrp.catalog"));
                URL url = module.getClassLoader().getResource("META-INF/jax-ws-catalog.xml");
                URLConnection connection = url.openConnection();
                if (!(connection instanceof JarURLConnection)) {
                    throw new RuntimeException("JAX-WS catalog not found");
                }
                JarFile jarFile = ((JarURLConnection)connection).getJarFile();
                moduleSpecification.addResourceLoader(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)ResourceLoaders.createJarResourceLoader((String)"wsrp-catalog", (JarFile)jarFile)));
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private boolean isWSRPPlugin(DeploymentUnit du) {
        ResourceRoot deploymentRoot;
        VirtualFile servicesDir;
        String name = du.getName();
        if (name.endsWith(".wsrp.jar")) {
            return true;
        }
        if (name.endsWith(".jar") && du.hasAttachment(GateInExtKey.KEY) && (servicesDir = (deploymentRoot = (ResourceRoot)du.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot().getChild("META-INF/services")).exists()) {
            for (String interfaceName : WSRPPostModuleDeploymentProcessor.KNOWN_PLUGIN_INTERFACE_NAMES) {
                if (!servicesDir.getChild(interfaceName).exists()) continue;
                return true;
            }
            log.debug((Object)("Looked at " + name + " using ServiceLoader but didn't contain any WSRP plugin marker. Ignoring."));
        }
        return false;
    }
}

