/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.jboss.as7.deployment;

import org.gatein.integration.jboss.as7.GateInConfiguration;
import org.gatein.integration.jboss.as7.GateInExtension;
import org.gatein.integration.jboss.as7.deployment.GateInConfigurationKey;
import org.gatein.integration.jboss.as7.deployment.GateInEarKey;
import org.gatein.integration.jboss.as7.deployment.GateInExtKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Services;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

public class GateInStructureDeploymentProcessor
implements DeploymentUnitProcessor {
    private static Logger log = Logger.getLogger(GateInStructureDeploymentProcessor.class);
    private static final ServiceListener listener = new AbstractServiceListener(){

        public void transition(ServiceController serviceController, ServiceController.Transition transition) {
            switch (transition) {
                case STARTING_to_UP: 
                case STOP_REQUESTED_to_UP: {
                    log.trace((Object)("Service started: " + serviceController.getName() + " [" + transition + "]"));
                    break;
                }
                case REMOVING_to_DOWN: 
                case START_FAILED_to_DOWN: 
                case START_REQUESTED_to_DOWN: 
                case STOPPING_to_DOWN: 
                case WAITING_to_DOWN: 
                case WONT_START_to_DOWN: {
                    log.trace((Object)("Service stopped: " + serviceController.getName() + " [" + transition + "]"));
                }
            }
        }
    };
    private GateInConfiguration config;

    public GateInStructureDeploymentProcessor(GateInConfiguration config) {
        this.config = config;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit du = phaseContext.getDeploymentUnit();
        log.debug((Object)("Deploy: " + du.getName() + " [" + phaseContext.getPhase() + "]"));
        if (du.getParent() != null) {
            this.processChildDeployment(phaseContext);
        } else {
            ModuleIdentifier moduleId = (ModuleIdentifier)du.getAttachment(Attachments.MODULE_IDENTIFIER);
            if (this.config.getGateInEarModule().equals(moduleId)) {
                log.debugf("Recognized %s as main GateIn deployment archive", (Object)moduleId);
                du.putAttachment(GateInEarKey.KEY, (Object)GateInEarKey.INSTANCE);
                du.putAttachment(GateInConfigurationKey.KEY, (Object)this.config);
                if (log.isTraceEnabled()) {
                    this.installListener(phaseContext, moduleId);
                }
            } else if (this.config.getGateInExtModules().contains(moduleId)) {
                log.debugf("Recognized %s as part of GateIn deployment", (Object)moduleId);
                du.putAttachment(GateInExtKey.KEY, (Object)GateInExtKey.INSTANCE);
                du.putAttachment(GateInConfigurationKey.KEY, (Object)this.config);
                if (log.isTraceEnabled()) {
                    this.installListener(phaseContext, moduleId);
                }
            }
        }
    }

    private void processChildDeployment(DeploymentPhaseContext phaseContext) {
        DeploymentUnit du = phaseContext.getDeploymentUnit();
        DeploymentUnit parent = du.getParent();
        if (GateInConfiguration.isGateInArchive(parent)) {
            du.putAttachment(GateInConfigurationKey.KEY, (Object)this.config);
            this.config.addChildSubUnit(Services.deploymentUnitName((String)parent.getName(), (String)du.getName()));
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    void installListener(DeploymentPhaseContext phaseContext, ModuleIdentifier moduleId) {
        ServiceName serviceName = Services.deploymentUnitName((String)GateInExtension.skipModuleLoaderPrefix(moduleId.getName()));
        ServiceController svcc = phaseContext.getServiceRegistry().getService(serviceName);
        svcc.addListener(ServiceListener.Inheritance.ALL, listener);
    }
}

