/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.jboss.as7.portal.resources;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public abstract class AbstractRuntimeResource
implements Resource.ResourceEntry {
    private final PathElement pathElement;

    public AbstractRuntimeResource(PathElement pathElement) {
        this.pathElement = pathElement;
    }

    public String getName() {
        return this.pathElement.getValue();
    }

    public PathElement getPathElement() {
        return this.pathElement;
    }

    public ModelNode getModel() {
        return new ModelNode();
    }

    public void writeModel(ModelNode newModel) {
        throw new UnsupportedOperationException("Writing to a 'runtime only' model is not allowed.");
    }

    public boolean isModelDefined() {
        return false;
    }

    public boolean hasChild(PathElement element) {
        return this.getChildrenNames(element.getKey()).contains(element.getValue());
    }

    public Resource getChild(PathElement element) {
        if (this.hasChildren(element.getKey())) {
            return this.getChildEntry(element.getValue());
        }
        return null;
    }

    public Resource requireChild(PathElement element) {
        Resource child = this.getChild(element);
        if (child == null) {
            throw new Resource.NoSuchResourceException(element);
        }
        return child;
    }

    public boolean hasChildren(String childType) {
        return this.getChildTypes().contains(childType);
    }

    public Resource navigate(PathAddress address) {
        if (address.size() == 0) {
            return this;
        }
        Resource child = this.requireChild(address.getElement(0));
        return address.size() == 1 ? child : child.navigate(address.subAddress(1));
    }

    public Set<String> getChildrenNames(String childType) {
        if (this.hasChildren(childType)) {
            return this.getChildrenNames();
        }
        return Collections.emptySet();
    }

    public Set<Resource.ResourceEntry> getChildren(String childType) {
        if (!this.hasChildren(childType)) {
            return Collections.emptySet();
        }
        LinkedHashSet<Resource.ResourceEntry> result = new LinkedHashSet<Resource.ResourceEntry>();
        for (String name : this.getChildrenNames()) {
            result.add(this.getChildEntry(name));
        }
        return result;
    }

    public void registerChild(PathElement address, Resource resource) {
        throw new UnsupportedOperationException("Cannot register child for a 'runtime only' model.");
    }

    public Resource removeChild(PathElement address) {
        throw new UnsupportedOperationException("Cannot remove child for a 'runtime only' model.");
    }

    public boolean isRuntime() {
        return true;
    }

    public boolean isProxy() {
        return false;
    }

    public Resource clone() {
        try {
            return (Resource)Resource.class.cast(super.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Should not have happened");
        }
    }

    protected abstract Set<String> getChildrenNames();

    protected abstract Resource.ResourceEntry getChildEntry(String var1);
}

