/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.jboss.as7.deployment;

import java.util.List;
import java.util.Map;
import org.gatein.integration.jboss.as7.GateInConfiguration;
import org.gatein.integration.jboss.as7.deployment.GateInConfigurationKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.web.deployment.TldsMetaData;
import org.jboss.metadata.web.spec.TldMetaData;

public class PortletWarClassloadingDependencyProcessor
implements DeploymentUnitProcessor {
    private List<TldMetaData> tldMetas;

    public PortletWarClassloadingDependencyProcessor(List<TldMetaData> tldMetaData) {
        this.tldMetas = tldMetaData;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit du = phaseContext.getDeploymentUnit();
        if (!GateInConfiguration.isPortletArchive(du)) {
            return;
        }
        ModuleSpecification moduleSpecification = (ModuleSpecification)du.getAttachment(Attachments.MODULE_SPECIFICATION);
        GateInConfiguration config = (GateInConfiguration)du.getAttachment(GateInConfigurationKey.KEY);
        for (ModuleDependency dep : config.getPortletWarDependencies()) {
            moduleSpecification.addSystemDependency(dep);
        }
        this.provideTlds(du);
    }

    private void provideTlds(DeploymentUnit deploymentUnit) {
        TldsMetaData tsmd = (TldsMetaData)deploymentUnit.getAttachment(TldsMetaData.ATTACHMENT_KEY);
        if (tsmd == null) {
            throw new IllegalStateException("Attachment not present: TldsMetaData");
        }
        Map tlds = tsmd.getTlds();
        if (tlds == null) {
            throw new IllegalStateException("TldsMetaData.tlds == null");
        }
        for (TldMetaData tld : this.tldMetas) {
            tlds.put(tld.getUri(), tld);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

