/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portlet.responsive.community;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndPerson;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.portlet.responsive.community.RssAuthorBean;
import org.gatein.portlet.responsive.community.RssTitleBean;

public class RomeRssControllerBean {
    private static final Logger log = LoggerFactory.getLogger(RomeRssControllerBean.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RssTitleBean> getFeedTitles(URL source, int headsize) throws IOException, FeedException {
        ArrayList<RssTitleBean> rssTitleBeanList = new ArrayList<RssTitleBean>();
        XmlReader reader = null;
        try {
            reader = new XmlReader(source);
            SyndFeed feed = new SyndFeedInput().build((Reader)reader);
            Iterator i = feed.getEntries().iterator();
            while (i.hasNext() && headsize-- > 0) {
                SyndEntry entry = (SyndEntry)i.next();
                RssTitleBean rssTitleBean = new RssTitleBean();
                rssTitleBean.setTitle(entry.getTitle());
                rssTitleBean.setLink(entry.getLink());
                rssTitleBean.setPublishedDate(entry.getPublishedDate());
                ArrayList<RssAuthorBean> rssAuthors = new ArrayList<RssAuthorBean>();
                for (SyndPerson author : entry.getAuthors()) {
                    RssAuthorBean rssAuthorBean = new RssAuthorBean();
                    rssAuthorBean.setName(author.getName());
                    rssAuthorBean.setUri(author.getUri());
                    rssAuthors.add(rssAuthorBean);
                }
                rssTitleBean.setAuthors(rssAuthors);
                rssTitleBeanList.add(rssTitleBean);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return rssTitleBeanList;
    }
}

