/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portlet.responsive.header;

import java.io.IOException;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.portlet.responsive.header.HeaderBean;
import org.gatein.portlet.responsive.header.NodePortlet;

public class HeaderPortlet
extends NodePortlet {
    private static final Logger log = LoggerFactory.getLogger(HeaderPortlet.class);
    private final int DEFAULT_NODE_LEVEL = 2;
    public static final String NODE_LEVEL_PREFERENCE = "level";
    HeaderBean headerBean = new HeaderBean(2);

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.headerBean.setNodeLevel(this.getNodeLevel((PortletRequest)request));
        request.setAttribute("headerbean", (Object)this.headerBean);
        PortletRequestDispatcher prd = this.getPortletContext().getRequestDispatcher("/jsp/header.jsp");
        prd.include(request, response);
    }

    protected int getNodeLevel(PortletRequest request) {
        int nodeLevel = 2;
        try {
            nodeLevel = Integer.valueOf(request.getPreferences().getValue(NODE_LEVEL_PREFERENCE, String.valueOf(2)));
        }
        catch (NumberFormatException nfe) {
            log.warn((Object)("Preference for Node level can only be an integer. Received invalid value of : " + request.getPreferences().getValue(NODE_LEVEL_PREFERENCE, null) + ". Using default value: " + 2));
        }
        if (nodeLevel < 2) {
            nodeLevel = 2;
            log.warn((Object)("Preference for Node level must be greater than 1. Current value of " + request.getPreferences().getValue(NODE_LEVEL_PREFERENCE, null) + " is invalid. Using default value of " + 2));
        }
        return nodeLevel;
    }
}

