/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portlet.responsive.header;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gatein.api.PortalRequest;
import org.gatein.api.navigation.Navigation;
import org.gatein.api.navigation.Node;
import org.gatein.api.navigation.NodePath;
import org.gatein.api.navigation.Nodes;
import org.gatein.api.navigation.Visibility;
import org.gatein.api.site.SiteId;

public class NodeBean {
    private final String EMPTY_CATEGORY_PROPERTY_NAME = "ShowEmptyCategories";
    private Node node;
    private SiteId siteId;
    List<NodeBean> children;
    protected boolean showEmptyCategories = false;
    private boolean emptyCategory;
    private boolean active = false;

    public List<NodeBean> getChildren() {
        return this.children;
    }

    public void setChildren(List<NodeBean> children) {
        this.children = children;
    }

    public void setEmptyCategory(boolean emptyCategory) {
        this.emptyCategory = emptyCategory;
    }

    public boolean isEmptyCategory() {
        return this.emptyCategory;
    }

    public boolean isSystem() {
        return this.node.getVisibility().getStatus().equals((Object)Visibility.Status.SYSTEM);
    }

    public NodeBean(Node node, SiteId siteId) {
        this(node, siteId, Boolean.valueOf(false));
    }

    public NodeBean(Node node, SiteId siteId, Boolean showEmptyCategories) {
        this.node = node;
        this.siteId = siteId;
        this.showEmptyCategories = showEmptyCategories;
        List nodeChildrenList = this.getChildren(node, siteId, false, showEmptyCategories.booleanValue());
        if (!showEmptyCategories.booleanValue()) {
            this.setEmptyCategory(this.isEmptyCategory(node));
        }
        this.setChildren(nodeChildrenList);
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        NodePath currentPath = PortalRequest.getInstance().getNodePath();
        NodePath nodePath = this.node.getNodePath();
        if (!this.active) {
            this.active = nodePath != null ? nodePath.equals((Object)currentPath) : false;
        }
        return this.active;
    }

    public String getPath() {
        return this.node.getNodePath().toString();
    }

    public String getSiteId() {
        return this.siteId.toString();
    }

    public boolean isPage() {
        return this.node.getPageId() != null;
    }

    public boolean isParent() {
        return this.node.getChildCount() > 0;
    }

    public String getName() {
        return this.node.getDisplayName();
    }

    public String getURI() {
        return this.node.getURI();
    }

    private boolean isEmptyCategory(Node n) {
        if (n.getPageId() != null) {
            return false;
        }
        Navigation navigation = PortalRequest.getInstance().getNavigation();
        Iterator iterator = n.iterator();
        while (iterator.hasNext()) {
            Node child = navigation.getNode(((Node)iterator.next()).getNodePath(), Nodes.visitNodes((int)1));
            if (child == null || this.isEmptyCategory(child)) continue;
            return false;
        }
        return true;
    }

    private List<NodeBean> getChildren(Node node, SiteId siteId, boolean firstActive, boolean showEmptyCategory) {
        ArrayList<NodeBean> nodes = new ArrayList<NodeBean>();
        boolean firstActiveSet = false;
        for (Node childNode : node) {
            NodeBean childNodeBean = new NodeBean(childNode, siteId);
            if (firstActive && !firstActiveSet) {
                childNodeBean.setActive(true);
                firstActiveSet = true;
            }
            if (!showEmptyCategory) {
                childNodeBean.setEmptyCategory(this.isEmptyCategory(childNode));
            }
            nodes.add(childNodeBean);
        }
        return nodes;
    }
}

