/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.expressions;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.lang.reflect.Method;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ValueExpression;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.expressions.Functions;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FunctionsTest
extends Assert {
    private Functions functions;

    @Before
    public void setUp() throws Exception {
        this.functions = new Functions(new Class[]{FunctionsTest.class});
    }

    @Test
    public void testExpose() throws Exception {
        Method hi = this.functions.resolveFunction("test", "hi");
        FunctionsTest.assertEquals((Object)"hi", (Object)hi.invoke(null, new Object[0]));
        Method hiAlternate = this.functions.resolveFunction("test", "hola");
        FunctionsTest.assertEquals((Object)"hi", (Object)hiAlternate.invoke(null, new Object[0]));
        Method bonjour = this.functions.resolveFunction("other", "bonjour");
        FunctionsTest.assertEquals((Object)"French hello", (Object)bonjour.invoke(null, new Object[0]));
    }

    @Test
    public void testNonStaticNotExposed() {
        FunctionsTest.assertNull((Object)this.functions.resolveFunction("test", "goodbye"));
    }

    @Test
    public void testDefaultBinding() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        this.functions = (Functions)injector.getInstance(Functions.class);
        Method toJson = this.functions.resolveFunction("osx", "parseJson");
        Object o = toJson.invoke(null, "{a : 1}");
        FunctionsTest.assertTrue((boolean)(o instanceof JSONObject));
        FunctionsTest.assertEquals((long)1L, (long)((JSONObject)o).getInt("a"));
    }

    @Test
    public void testExpressionEvaluation() {
        Expressions expressions = Expressions.forTesting((Functions)this.functions);
        ELContext context = expressions.newELContext(new ELResolver[0]);
        ValueExpression expression = expressions.parse("${other:bonjour()}", String.class);
        FunctionsTest.assertEquals((Object)"French hello", (Object)expression.getValue(context));
        expression = expressions.parse("${test:add(1, 2)}", Integer.class);
        FunctionsTest.assertEquals((Object)3, (Object)expression.getValue(context));
    }

    @Functions.Expose(prefix="test", names={"hi", "hola"})
    public static String sayHi() {
        return "hi";
    }

    @Functions.Expose(prefix="test", names={"add"})
    public static int add(int i, int j) {
        return i + j;
    }

    @Functions.Expose(prefix="other", names={"bonjour"})
    public static String sayHi2() {
        return "French hello";
    }

    @Functions.Expose(prefix="test", names={"goodbye"})
    public String sayGoodbye() {
        return "goodbye";
    }
}

