/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.expressions.juel;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ValueExpression;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.expressions.RootELResolver;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JuelExpressionsTest {
    private Expressions expressions;
    private ELContext context;
    private Map<String, Object> variables;

    @Before
    public void setUp() {
        this.expressions = Expressions.forTesting(null);
        this.variables = Maps.newHashMap();
        this.context = this.expressions.newELContext(new ELResolver[]{new RootELResolver(this.variables)});
    }

    @Test
    public void booleanCoercionOfStringsFails() throws Exception {
        this.addVariable("bool", "FALSE");
        Assert.assertFalse((boolean)this.evaluate("${!bool}", Boolean.class));
        this.addVariable("bool", "booga");
        Assert.assertFalse((boolean)this.evaluate("${!bool}", Boolean.class));
    }

    @Test
    public void booleanCoercionOfNumbersFails() throws Exception {
        this.addVariable("bool", 0);
        Assert.assertTrue((boolean)this.evaluate("${!bool}", Boolean.class));
        this.addVariable("bool", 1);
        Assert.assertFalse((boolean)this.evaluate("${!bool}", Boolean.class));
        this.evaluate("${true && 5}", String.class);
    }

    private <T> T evaluate(String expression, Class<T> type) {
        ValueExpression expr = this.expressions.parse(expression, type);
        return type.cast(expr.getValue(this.context));
    }

    private void addVariable(String key, Object value) {
        this.variables.put(key, value);
    }
}

