/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.conversion;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.protocol.conversion.BeanDelegator;
import org.apache.shindig.protocol.conversion.BeanDelegatorTest;
import org.apache.shindig.protocol.conversion.BeanFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BeanFilterTest
extends Assert {
    private BeanFilter beanFilter;
    private BeanDelegator beanDelegator;

    @Before
    public void setUp() {
        this.beanFilter = new BeanFilter();
        this.beanDelegator = BeanDelegatorTest.createSimpleDelegator();
    }

    @Test
    public void testNull() throws Exception {
        BeanFilterTest.assertNull((Object)this.beanFilter.createFilteredBean(null, (Set)ImmutableSet.of((Object)"s")));
    }

    @Test
    public void testSimple() throws Exception {
        String data = "data";
        String newData = (String)this.beanFilter.createFilteredBean((Object)data, null);
        BeanFilterTest.assertSame((Object)data, (Object)newData);
    }

    @Test
    public void testInt() throws Exception {
        BeanDelegatorTest.SimpleBean data = new BeanDelegatorTest.SimpleBean().setI(5);
        BeanDelegatorTest.SimpleBeanInterface dataBean = (BeanDelegatorTest.SimpleBeanInterface)this.beanDelegator.createDelegator((Object)data);
        BeanDelegatorTest.SimpleBeanInterface newData = (BeanDelegatorTest.SimpleBeanInterface)this.beanFilter.createFilteredBean((Object)dataBean, (Set)ImmutableSet.of((Object)"i"));
        BeanFilterTest.assertEquals((long)5L, (long)newData.getI());
        newData = (BeanDelegatorTest.SimpleBeanInterface)this.beanFilter.createFilteredBean((Object)dataBean, (Set)ImmutableSet.of((Object)"s"));
        BeanFilterTest.assertEquals((long)5L, (long)newData.getI());
    }

    @Test
    public void testString() throws Exception {
        BeanDelegatorTest.SimpleBean data = new BeanDelegatorTest.SimpleBean().setS("data");
        BeanDelegatorTest.SimpleBeanInterface dataBean = (BeanDelegatorTest.SimpleBeanInterface)this.beanDelegator.createDelegator((Object)data);
        BeanDelegatorTest.SimpleBeanInterface newData = (BeanDelegatorTest.SimpleBeanInterface)this.beanFilter.createFilteredBean((Object)dataBean, (Set)ImmutableSet.of((Object)"s"));
        BeanFilterTest.assertEquals((Object)"data", (Object)newData.getS());
        newData = (BeanDelegatorTest.SimpleBeanInterface)this.beanFilter.createFilteredBean((Object)dataBean, (Set)ImmutableSet.of((Object)"i"));
        BeanFilterTest.assertNull((String)"S is filtered out", (Object)newData.getS());
        BeanFilterTest.assertNotNull((String)"Required field", (Object)newData.getRequired());
    }

    @Test
    public void testList() throws Exception {
        BeanDelegatorTest.SimpleBean data = new BeanDelegatorTest.SimpleBean().setList((List<String>)ImmutableList.of((Object)"d1", (Object)"d2"));
        BeanDelegatorTest.SimpleBeanInterface dataBean = (BeanDelegatorTest.SimpleBeanInterface)this.beanDelegator.createDelegator((Object)data);
        BeanDelegatorTest.SimpleBeanInterface newData = (BeanDelegatorTest.SimpleBeanInterface)this.beanFilter.createFilteredBean((Object)dataBean, (Set)ImmutableSet.of((Object)"s"));
        BeanFilterTest.assertEquals(null, newData.getList());
        newData = (BeanDelegatorTest.SimpleBeanInterface)this.beanFilter.createFilteredBean((Object)dataBean, (Set)ImmutableSet.of((Object)"list"));
        BeanFilterTest.assertArrayEquals((Object[])data.getList().toArray(), (Object[])newData.getList().toArray());
    }

    @Test
    public void testMap() throws Exception {
        ImmutableList list = ImmutableList.of((Object)"test");
        BeanDelegatorTest.SimpleBean data = new BeanDelegatorTest.SimpleBean().setS("Main").setBeanMap((Map<String, BeanDelegatorTest.SimpleBean>)ImmutableMap.of((Object)"s1", (Object)new BeanDelegatorTest.SimpleBean().setS("sub1").setList((List<String>)list), (Object)"s2", (Object)new BeanDelegatorTest.SimpleBean().setS("sub2").setList((List<String>)list).setBeanMap((Map<String, BeanDelegatorTest.SimpleBean>)ImmutableMap.of((Object)"s2s1", (Object)new BeanDelegatorTest.SimpleBean().setS("sub2-sub1")))));
        BeanDelegatorTest.SimpleBeanInterface dataBean = (BeanDelegatorTest.SimpleBeanInterface)this.beanDelegator.createDelegator((Object)data);
        BeanDelegatorTest.SimpleBeanInterface newData = (BeanDelegatorTest.SimpleBeanInterface)this.beanFilter.createFilteredBean((Object)dataBean, (Set)ImmutableSet.of((Object)"beanmap"));
        BeanFilterTest.assertEquals((long)2L, (long)newData.getBeanMap().size());
        BeanFilterTest.assertEquals(null, (Object)newData.getBeanMap().get("s1").getS());
        newData = (BeanDelegatorTest.SimpleBeanInterface)this.beanFilter.createFilteredBean((Object)dataBean, (Set)ImmutableSet.of((Object)"beanmap", (Object)"beanmap.s"));
        BeanFilterTest.assertNotSame(dataBean.getBeanMap().getClass(), newData.getBeanMap().getClass());
        BeanFilterTest.assertEquals((long)2L, (long)newData.getBeanMap().size());
        BeanFilterTest.assertEquals((Object)"sub1", (Object)newData.getBeanMap().get("s1").getS());
        BeanFilterTest.assertNull((String)"List is filtered out", newData.getBeanMap().get("s1").getList());
        newData = (BeanDelegatorTest.SimpleBeanInterface)this.beanFilter.createFilteredBean((Object)dataBean, (Set)ImmutableSet.of((Object)"beanmap", (Object)"beanmap.*"));
        BeanFilterTest.assertSame(dataBean.getBeanMap().getClass(), newData.getBeanMap().getClass());
        newData = (BeanDelegatorTest.SimpleBeanInterface)this.beanFilter.createFilteredBean((Object)dataBean, (Set)ImmutableSet.of((Object)"beanmap", (Object)"beanmap.beanmap", (Object)"beanmap.beanmap.s"));
        BeanFilterTest.assertEquals((long)2L, (long)newData.getBeanMap().size());
        Map<String, BeanDelegatorTest.SimpleBeanInterface> subSubMap = newData.getBeanMap().get("s2").getBeanMap();
        BeanFilterTest.assertEquals((long)1L, (long)subSubMap.size());
        BeanFilterTest.assertEquals((Object)"sub2-sub1", (Object)subSubMap.get("s2s1").getS());
        BeanFilterTest.assertNull((String)"list is filtered", subSubMap.get("s2s1").getList());
        newData = (BeanDelegatorTest.SimpleBeanInterface)this.beanFilter.createFilteredBean((Object)dataBean, (Set)ImmutableSet.of((Object)"beanmap", (Object)"beanmap.beanmap", (Object)"beanmap.beanmap.*"));
        BeanFilterTest.assertEquals((long)2L, (long)newData.getBeanMap().size());
        BeanFilterTest.assertNotSame(dataBean.getBeanMap().getClass(), newData.getBeanMap().getClass());
        BeanFilterTest.assertSame(data.getBeanMap().get("s2").getBeanMap().getClass(), newData.getBeanMap().get("s2").getBeanMap().getClass());
    }

    @Test
    public void testProcessFields() {
        ImmutableSet srcFields = ImmutableSet.of((Object)"A", (Object)"b", (Object)"c.d.e.f", (Object)"Case", (Object)"cAse", (Object)"CASE", (Object[])new String[0]);
        Set newFields = this.beanFilter.processBeanFields((Collection)srcFields);
        BeanFilterTest.assertEquals((long)7L, (long)newFields.size());
        BeanFilterTest.assertTrue((boolean)newFields.contains("a"));
        BeanFilterTest.assertTrue((boolean)newFields.contains("b"));
        BeanFilterTest.assertTrue((boolean)newFields.contains("c"));
        BeanFilterTest.assertTrue((boolean)newFields.contains("c.d"));
        BeanFilterTest.assertTrue((boolean)newFields.contains("c.d.e"));
        BeanFilterTest.assertTrue((boolean)newFields.contains("c.d.e.f"));
        BeanFilterTest.assertTrue((boolean)newFields.contains("case"));
    }

    @Test
    public void testListFields() {
        List fields = this.beanFilter.getBeanFields(BeanDelegatorTest.SimpleBeanInterface.class, 3);
        BeanFilterTest.assertTrue((boolean)fields.contains("Map"));
        BeanFilterTest.assertTrue((boolean)fields.contains("I"));
        BeanFilterTest.assertTrue((boolean)fields.contains("S"));
        BeanFilterTest.assertTrue((boolean)fields.contains("Style"));
        BeanFilterTest.assertTrue((boolean)fields.contains("List"));
        BeanFilterTest.assertTrue((boolean)fields.contains("BeanList.List"));
        BeanFilterTest.assertTrue((boolean)fields.contains("Map"));
        BeanFilterTest.assertTrue((boolean)fields.contains("BeanMap.List"));
        BeanFilterTest.assertTrue((boolean)fields.contains("BeanMap.BeanMap.BeanMap"));
        BeanFilterTest.assertFalse((boolean)fields.contains("BeanMap.BeanMap.BeanMap.BeanMap"));
        BeanFilterTest.assertEquals((long)77L, (long)fields.size());
    }
}

