/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.jboss;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.catalina.Engine;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.core.StandardServer;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.wci.jboss.JB7ServletContainerContext;

public class CatalinaIntegration {
    private static final Logger log = LoggerFactory.getLogger(CatalinaIntegration.class);
    private static final String CROSS_CONTEXT_LOGOUT_KEY = "org.gatein.wci.cross_context_logout";
    private StandardServer server;
    protected final AtomicBoolean start = new AtomicBoolean(false);
    private LinkedHashMap<Engine, JB7ServletContainerContext> containerContexts = new LinkedHashMap();

    public CatalinaIntegration(StandardServer server) {
        this.server = server;
    }

    public void start() {
        if (this.start.compareAndSet(false, true)) {
            this.start((Server)this.server);
        }
    }

    private void start(Server server) {
        List<Service> services = Arrays.asList(server.findServices());
        for (Service service : services) {
            Engine engine = (Engine)service.getContainer();
            JB7ServletContainerContext containerContext = new JB7ServletContainerContext(engine);
            containerContext.setCrossContextLogout(this.getCrossContextLogoutConfig());
            containerContext.start();
            this.containerContexts.put(engine, containerContext);
        }
    }

    public void stop() {
        if (this.start.compareAndSet(true, false)) {
            this.stop((Server)this.server);
        }
    }

    private void stop(Server server) {
        List<Service> services = Arrays.asList(server.findServices());
        for (Service service : services) {
            Engine engine = (Engine)service.getContainer();
            JB7ServletContainerContext containerContext = this.containerContexts.get(engine);
            containerContext.stop();
            this.containerContexts.remove(engine);
        }
    }

    private boolean getCrossContextLogoutConfig() {
        String val = System.getProperty(CROSS_CONTEXT_LOGOUT_KEY);
        if (val == null || Boolean.valueOf(val).booleanValue()) {
            return true;
        }
        if (!"false".equalsIgnoreCase(val)) {
            log.warn((Object)("System property org.gatein.wci.cross_context_logout value is invalid: [" + val + "] - falling back to: [false]"));
        }
        log.info((Object)"Cross-context session invalidation on logout disabled");
        return false;
    }
}

