/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.spec.v2;

import org.gatein.wsrp.WSRPExceptionFactory;
import org.gatein.wsrp.WSRPTypeFactory;
import org.oasis.wsrp.v2.AccessDenied;
import org.oasis.wsrp.v2.ExportByValueNotSupported;
import org.oasis.wsrp.v2.ExportNoLongerValid;
import org.oasis.wsrp.v2.Fault;
import org.oasis.wsrp.v2.InconsistentParameters;
import org.oasis.wsrp.v2.InvalidCookie;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.InvalidSession;
import org.oasis.wsrp.v2.InvalidUserCategory;
import org.oasis.wsrp.v2.MissingParameters;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.OperationNotSupported;
import org.oasis.wsrp.v2.PortletStateChangeRequired;
import org.oasis.wsrp.v2.ResourceSuspended;
import org.oasis.wsrp.v2.UnsupportedLocale;
import org.oasis.wsrp.v2.UnsupportedMimeType;
import org.oasis.wsrp.v2.UnsupportedMode;
import org.oasis.wsrp.v2.UnsupportedWindowState;

public class WSRP2ExceptionFactory
extends WSRPExceptionFactory {
    @Override
    protected void loadExceptionFactories() {
        try {
            exceptionClassToFactory.put(AccessDenied.class, new V2ExceptionFactory<AccessDenied>(AccessDenied.class));
            exceptionClassToFactory.put(ExportByValueNotSupported.class, new V2ExceptionFactory<ExportByValueNotSupported>(ExportByValueNotSupported.class));
            exceptionClassToFactory.put(ExportNoLongerValid.class, new V2ExceptionFactory<ExportNoLongerValid>(ExportNoLongerValid.class));
            exceptionClassToFactory.put(InconsistentParameters.class, new V2ExceptionFactory<InconsistentParameters>(InconsistentParameters.class));
            exceptionClassToFactory.put(InvalidCookie.class, new V2ExceptionFactory<InvalidCookie>(InvalidCookie.class));
            exceptionClassToFactory.put(InvalidHandle.class, new V2ExceptionFactory<InvalidHandle>(InvalidHandle.class));
            exceptionClassToFactory.put(InvalidRegistration.class, new V2ExceptionFactory<InvalidRegistration>(InvalidRegistration.class));
            exceptionClassToFactory.put(InvalidSession.class, new V2ExceptionFactory<InvalidSession>(InvalidSession.class));
            exceptionClassToFactory.put(InvalidUserCategory.class, new V2ExceptionFactory<InvalidUserCategory>(InvalidUserCategory.class));
            exceptionClassToFactory.put(MissingParameters.class, new V2ExceptionFactory<MissingParameters>(MissingParameters.class));
            exceptionClassToFactory.put(ModifyRegistrationRequired.class, new V2ExceptionFactory<ModifyRegistrationRequired>(ModifyRegistrationRequired.class));
            exceptionClassToFactory.put(OperationFailed.class, new V2ExceptionFactory<OperationFailed>(OperationFailed.class));
            exceptionClassToFactory.put(OperationNotSupported.class, new V2ExceptionFactory<OperationNotSupported>(OperationNotSupported.class));
            exceptionClassToFactory.put(PortletStateChangeRequired.class, new V2ExceptionFactory<PortletStateChangeRequired>(PortletStateChangeRequired.class));
            exceptionClassToFactory.put(ResourceSuspended.class, new V2ExceptionFactory<ResourceSuspended>(ResourceSuspended.class));
            exceptionClassToFactory.put(UnsupportedLocale.class, new V2ExceptionFactory<UnsupportedLocale>(UnsupportedLocale.class));
            exceptionClassToFactory.put(UnsupportedMimeType.class, new V2ExceptionFactory<UnsupportedMimeType>(UnsupportedMimeType.class));
            exceptionClassToFactory.put(UnsupportedMode.class, new V2ExceptionFactory<UnsupportedMode>(UnsupportedMode.class));
            exceptionClassToFactory.put(UnsupportedWindowState.class, new V2ExceptionFactory<UnsupportedWindowState>(UnsupportedWindowState.class));
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't initialize WSRPExceptionFactory", e);
        }
    }

    public static WSRPExceptionFactory getInstance() {
        return InstanceHolder.factory;
    }

    private WSRP2ExceptionFactory() {
    }

    public static void throwMissingParametersIfValueIsMissing(Object valueToCheck, String valueName, String context) throws MissingParameters {
        if (valueToCheck == null) {
            throw new MissingParameters("Missing required " + valueName + (context != null ? " in " + context : ""), WSRPTypeFactory.createMissingParametersFault());
        }
    }

    public static void throwOperationFailedIfValueIsMissing(Object valueToCheck, String valueName) throws OperationFailed {
        if (valueToCheck == null) {
            throw new OperationFailed("Missing required " + valueName, WSRPTypeFactory.createOperationFailedFault());
        }
    }

    protected static class V2ExceptionFactory<E extends Exception>
    extends WSRPExceptionFactory.ExceptionFactory {
        public V2ExceptionFactory(Class<E> exceptionClass) throws NoSuchMethodException, IllegalAccessException, InstantiationException, ClassNotFoundException {
            super(exceptionClass);
        }

        @Override
        protected Class initFaultAndGetClass(Class clazz) throws IllegalAccessException, InstantiationException {
            if (Fault.class.isAssignableFrom(clazz)) {
                Class faultClass = clazz;
                this.fault = faultClass.newInstance();
                return faultClass;
            }
            throw new IllegalArgumentException("Couldn't create fault class based on specified exception class from " + clazz);
        }
    }

    private static final class InstanceHolder {
        public static final WSRP2ExceptionFactory factory = new WSRP2ExceptionFactory();

        private InstanceHolder() {
        }
    }
}

