/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.gatein.common.i18n.LocaleFormat;
import org.gatein.common.net.URLTools;
import org.gatein.common.util.ConversionException;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.StatefulPortletContext;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.cache.CacheLevel;
import org.gatein.pc.api.state.AccessMode;
import org.gatein.wsrp.PropertyAccessor;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.registration.LocalizedString;
import org.gatein.wsrp.registration.RegistrationPropertyDescription;
import org.oasis.wsrp.v2.InteractionParams;
import org.oasis.wsrp.v2.MarkupParams;
import org.oasis.wsrp.v2.NamedString;
import org.oasis.wsrp.v2.NavigationalContext;
import org.oasis.wsrp.v2.PortletContext;
import org.oasis.wsrp.v2.PropertyDescription;
import org.oasis.wsrp.v2.StateChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSRPUtils {
    private static final Map<String, String> JSR168_WSRP_WINDOW_STATES = new HashMap<String, String>(7);
    private static final Map<String, WindowState> WSRP_JSR168_WINDOW_STATES = new HashMap<String, WindowState>(7);
    private static final Map<String, String> JSR168_WSRP_MODES = new HashMap<String, String>(7);
    private static final Map<String, Mode> WSRP_JSR168_MODES = new HashMap<String, Mode>(7);
    private static final Map<CacheLevel, String> JSR286_WSRP_CACHE = new HashMap<CacheLevel, String>(7);
    private static final String SET_OF_LOCALES = "set of Locales";
    private static final String MODE = "Mode";
    private static final String WSRP_MODE_NAME = "wsrp portlet name";
    private static final String WSRP_WINDOW_STATE_NAME = "wsrp window state name";
    private static final String WINDOW_STATE = "WindowState";
    public static final Set<Mode> DEFAULT_JSR168_MODES;
    public static final Set<WindowState> DEFAULT_JSR168_WINDOWSTATES;
    private static boolean strict;
    private static Logger log;
    private static PropertyAccessor propertyAccessor;
    public static final String DEACTIVATE_URL_REWRITING = "org.gatein.wsrp.producer.deactivateURLRewriting";

    public static void setStrict(boolean strict) {
        WSRPUtils.strict = strict;
        log.debug("Using " + (strict ? "strict" : "lenient") + " language code validation mode.");
    }

    private WSRPUtils() {
    }

    public static WindowState getJSR168WindowStateFromWSRPName(String wsrpWindowStateName) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)wsrpWindowStateName, (String)WSRP_WINDOW_STATE_NAME, null);
        WindowState windowState = WSRP_JSR168_WINDOW_STATES.get(wsrpWindowStateName);
        return windowState == null ? WindowState.create((String)wsrpWindowStateName) : windowState;
    }

    public static boolean isDefaultWSRPWindowState(String wsrpWindowStateName) {
        return WSRP_JSR168_WINDOW_STATES.containsKey(wsrpWindowStateName) || "wsrp:solo".equals(wsrpWindowStateName);
    }

    public static String convertJSR168WindowStateNameToWSRPName(String jsr168WindowStateName) {
        if (jsr168WindowStateName == null) {
            return "wsrp:normal";
        }
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)jsr168WindowStateName, (String)WSRP_WINDOW_STATE_NAME, null);
        String wsrpName = JSR168_WSRP_WINDOW_STATES.get(jsr168WindowStateName);
        return wsrpName == null ? jsr168WindowStateName : wsrpName;
    }

    public static String getWSRPNameFromJSR168WindowState(WindowState windowState) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)windowState, (String)WINDOW_STATE);
        return WSRPUtils.convertJSR168WindowStateNameToWSRPName(windowState.toString());
    }

    public static Mode getJSR168PortletModeFromWSRPName(String wsrpPortletModeName) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)wsrpPortletModeName, (String)WSRP_MODE_NAME, null);
        Mode mode = WSRP_JSR168_MODES.get(wsrpPortletModeName);
        return mode == null ? Mode.create((String)wsrpPortletModeName) : mode;
    }

    public static boolean isDefaultWSRPMode(String wsrpPortletModeName) {
        return WSRP_JSR168_MODES.containsKey(wsrpPortletModeName) || "wsrp:preview".equals(wsrpPortletModeName);
    }

    public static String convertJSR168PortletModeNameToWSRPName(String jsr168PortletModeName) {
        if (jsr168PortletModeName == null) {
            return "wsrp:view";
        }
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)jsr168PortletModeName, (String)WSRP_MODE_NAME, null);
        String wsrpName = JSR168_WSRP_MODES.get(jsr168PortletModeName);
        return wsrpName == null ? jsr168PortletModeName : wsrpName;
    }

    public static String getWSRPNameFromJSR168PortletMode(Mode portletMode) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletMode, (String)MODE);
        return WSRPUtils.convertJSR168PortletModeNameToWSRPName(portletMode.toString());
    }

    public static AccessMode getAccessModeFromStateChange(StateChange stateChange) {
        if (StateChange.READ_ONLY.equals((Object)stateChange)) {
            return AccessMode.READ_ONLY;
        }
        if (StateChange.CLONE_BEFORE_WRITE.equals((Object)stateChange)) {
            return AccessMode.CLONE_BEFORE_WRITE;
        }
        if (StateChange.READ_WRITE.equals((Object)stateChange)) {
            return AccessMode.READ_WRITE;
        }
        throw new IllegalArgumentException("Unsupported StateChange: " + stateChange);
    }

    public static StateChange getStateChangeFromAccessMode(AccessMode accessMode) {
        if (AccessMode.READ_ONLY.equals((Object)accessMode)) {
            return StateChange.READ_ONLY;
        }
        if (AccessMode.READ_WRITE.equals((Object)accessMode)) {
            return StateChange.READ_WRITE;
        }
        if (AccessMode.CLONE_BEFORE_WRITE.equals((Object)accessMode)) {
            return StateChange.CLONE_BEFORE_WRITE;
        }
        throw new IllegalArgumentException("Unsupported AccessMode: " + accessMode);
    }

    public static String convertRequestAuthTypeToWSRPAuthType(String authType) {
        if (authType == null) {
            return "wsrp:none";
        }
        if ("CLIENT_CERT".equals(authType)) {
            return "wsrp:certificate";
        }
        if ("BASIC".equalsIgnoreCase(authType) || "FORM".equals(authType)) {
            return "wsrp:password";
        }
        return authType;
    }

    public static List<String> convertLocalesToRFC3066LanguageTags(List<Locale> localesOrderedByPreference) {
        ParameterValidation.throwIllegalArgExceptionIfNull(localesOrderedByPreference, (String)SET_OF_LOCALES);
        ArrayList<String> desiredLocales = new ArrayList<String>(localesOrderedByPreference.size());
        for (Locale locale : localesOrderedByPreference) {
            desiredLocales.add(WSRPUtils.toString(locale));
        }
        return desiredLocales;
    }

    public static org.gatein.pc.api.PortletContext convertToPortalPortletContext(PortletContext portletContext) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        String handle = portletContext.getPortletHandle();
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)handle, (String)"portlet handle", (String)"PortletContext");
        byte[] state = portletContext.getPortletState();
        org.gatein.pc.api.PortletContext context = org.gatein.pc.api.PortletContext.createPortletContext((String)handle, (byte[])state, (boolean)false);
        return context;
    }

    public static org.gatein.pc.api.PortletContext convertToPortalPortletContext(String portletHandle, byte[] state) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)portletHandle, (String)"portlet handle", (String)"PortletContext");
        org.gatein.pc.api.PortletContext context = org.gatein.pc.api.PortletContext.createPortletContext((String)portletHandle, (byte[])state, (boolean)false);
        return context;
    }

    public static PortletContext convertToWSRPPortletContext(org.gatein.pc.api.PortletContext portletContext) {
        StatefulPortletContext context;
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        String id = portletContext.getId();
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)id, (String)"portlet id", (String)"PortletContext");
        PortletContext result = WSRPTypeFactory.createPortletContext(id);
        if (portletContext instanceof StatefulPortletContext && PortletStateType.OPAQUE.equals((context = (StatefulPortletContext)portletContext).getType())) {
            result.setPortletState((byte[])context.getState());
        }
        return result;
    }

    public static String getResourceCacheabilityFromCacheLevel(CacheLevel cacheLevel) {
        return cacheLevel == null ? null : cacheLevel.name().toLowerCase(Locale.ENGLISH);
    }

    public static CacheLevel getCacheLevelFromResourceCacheability(String resourceCacheability) {
        if (resourceCacheability == null) {
            return CacheLevel.PAGE;
        }
        return CacheLevel.create((String)resourceCacheability.toUpperCase(Locale.ENGLISH));
    }

    public static Locale getLocale(String lang) throws IllegalArgumentException {
        if (lang != null) {
            String possiblyRelaxed = lang;
            if (!strict) {
                possiblyRelaxed = lang.replace('_', '-');
            }
            try {
                return LocaleFormat.RFC3066_LANGUAGE_TAG.getLocale(possiblyRelaxed);
            }
            catch (ConversionException e) {
                if (strict) {
                    throw new IllegalArgumentException(e);
                }
                log.debug("Was given an invalid language: '" + possiblyRelaxed + "'. Since we're using relaxed validation, we will assume " + Locale.ENGLISH + " to avoid crashing!", (Throwable)e);
                return Locale.ENGLISH;
            }
        }
        return Locale.getDefault();
    }

    public static String toString(Locale locale) throws IllegalArgumentException {
        try {
            return LocaleFormat.RFC3066_LANGUAGE_TAG.toString(locale);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toString(MarkupParams params) {
        if (params != null) {
            StringBuffer sb = new StringBuffer("MarkupParams");
            if (params.isSecureClientCommunication()) {
                sb.append("(secure)");
            }
            NavigationalContext navigationalContext = params.getNavigationalContext();
            sb.append("[M=").append(params.getMode()).append("][WS=").append(params.getWindowState()).append("]");
            if (navigationalContext != null) {
                sb.append("[private NS=").append(navigationalContext.getOpaqueValue()).append("]").append("[public NS=").append(navigationalContext.getPublicValues()).append("]");
            }
            return sb.toString();
        }
        return null;
    }

    public static String toString(InteractionParams interactionParams) {
        if (interactionParams != null) {
            StringBuffer sb = new StringBuffer("InteractionParams");
            sb.append("[IS=").append(interactionParams.getInteractionState()).append("]").append("[StateChange=").append(interactionParams.getPortletStateChange().value()).append("]");
            List formParams = interactionParams.getFormParameters();
            if (formParams != null) {
                sb.append("\n\tForm params:\n");
                for (NamedString formParam : formParams) {
                    sb.append("\t\t").append(formParam.getName()).append("='").append(formParam.getValue()).append("'\n");
                }
            }
            return sb.toString();
        }
        return null;
    }

    public static RegistrationPropertyDescription convertToRegistrationPropertyDescription(PropertyDescription propertyDescription) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyDescription, (String)"PropertyDescription");
        RegistrationPropertyDescription desc = new RegistrationPropertyDescription(propertyDescription.getName(), propertyDescription.getType());
        desc.setLabel(WSRPUtils.getLocalizedStringOrNull(propertyDescription.getLabel()));
        desc.setHint(WSRPUtils.getLocalizedStringOrNull(propertyDescription.getHint()));
        return desc;
    }

    public static PropertyDescription convertToPropertyDescription(RegistrationPropertyDescription propertyDescription) {
        LocalizedString label;
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyDescription, (String)"RegistrationPropertyDescription");
        PropertyDescription propDesc = WSRPTypeFactory.createPropertyDescription(propertyDescription.getName().toString(), propertyDescription.getType());
        LocalizedString hint = propertyDescription.getHint();
        if (hint != null) {
            propDesc.setHint(WSRPUtils.convertToWSRPLocalizedString(hint));
        }
        if ((label = propertyDescription.getLabel()) != null) {
            propDesc.setLabel(WSRPUtils.convertToWSRPLocalizedString(label));
        }
        return propDesc;
    }

    public static org.oasis.wsrp.v2.LocalizedString convertToWSRPLocalizedString(LocalizedString regLocalizedString) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)regLocalizedString, (String)"LocalizedString");
        return WSRPTypeFactory.createLocalizedString(WSRPUtils.toString(regLocalizedString.getLocale()), regLocalizedString.getResourceName(), regLocalizedString.getValue());
    }

    private static LocalizedString getLocalizedStringOrNull(org.oasis.wsrp.v2.LocalizedString wsrpLocalizedString) {
        if (wsrpLocalizedString == null) {
            return null;
        }
        return WSRPUtils.convertToRegistrationLocalizedString(wsrpLocalizedString);
    }

    public static LocalizedString convertToRegistrationLocalizedString(org.oasis.wsrp.v2.LocalizedString wsrpLocalizedString) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)wsrpLocalizedString, (String)"WSRP LocalizedString");
        String lang = wsrpLocalizedString.getLang();
        Locale locale = lang == null ? Locale.getDefault() : WSRPUtils.getLocale(lang);
        LocalizedString localizedString = new LocalizedString(wsrpLocalizedString.getValue(), locale);
        localizedString.setResourceName(wsrpLocalizedString.getResourceName());
        return localizedString;
    }

    public static String getAbsoluteURLFor(String url, boolean checkWSRPToken, String serverAddress) {
        if (checkWSRPToken && url.startsWith("wsrp_rewrite?")) {
            return url;
        }
        if (!URLTools.isNetworkURL((String)url) && url.startsWith("/")) {
            return serverAddress + url;
        }
        return url;
    }

    public static <F, T> List<T> transform(List<F> fromList, Function<? super F, ? extends T> function) {
        if (fromList == null) {
            return null;
        }
        return Lists.transform(fromList, function);
    }

    public static org.gatein.common.i18n.LocalizedString convertToCommonLocalizedStringOrNull(org.oasis.wsrp.v2.LocalizedString wsrpLocalizedString) {
        if (wsrpLocalizedString != null) {
            return new org.gatein.common.i18n.LocalizedString(wsrpLocalizedString.getValue(), WSRPUtils.getLocale(wsrpLocalizedString.getLang()));
        }
        return null;
    }

    public static Map<String, String[]> createPublicNSFrom(List<NamedString> publicParams) {
        HashMap<String, String[]> publicNS = new HashMap<String, String[]>(publicParams.size());
        for (NamedString publicParam : publicParams) {
            String paramName = publicParam.getName();
            WSRPUtils.addMultiValuedValueTo(publicNS, paramName, publicParam.getValue());
        }
        return publicNS;
    }

    public static void addMultiValuedValueTo(Map<String, String[]> paramMap, String paramName, String paramValue) {
        Object[] values = paramMap.get(paramName);
        if (ParameterValidation.existsAndIsNotEmpty((Object[])values)) {
            int valuesNb = values.length;
            String[] newValues = new String[valuesNb + 1];
            System.arraycopy(values, 0, newValues, 0, valuesNb);
            newValues[valuesNb] = paramValue;
            paramMap.put(paramName, newValues);
        } else {
            values = new String[]{paramValue};
            paramMap.put(paramName, (String[])values);
        }
    }

    public static String encodePublicNS(Map<String, String[]> publicNSChanges) {
        if (ParameterValidation.existsAndIsNotEmpty(publicNSChanges)) {
            StringBuilder sb = new StringBuilder(128);
            Set<Map.Entry<String, String[]>> entries = publicNSChanges.entrySet();
            int entryNb = entries.size();
            int currentEntry = 0;
            for (Map.Entry<String, String[]> entry : entries) {
                String name = entry.getKey();
                Object[] values = entry.getValue();
                if (ParameterValidation.existsAndIsNotEmpty((Object[])values)) {
                    int valueNb = values.length;
                    int currentValueIndex = 0;
                    for (Object value : values) {
                        sb.append(name).append("=").append((String)value);
                        if (currentValueIndex++ == valueNb - 1) continue;
                        sb.append("&");
                    }
                } else {
                    sb.append(name);
                }
                if (currentEntry++ == entryNb - 1) continue;
                sb.append("&");
            }
            return URLTools.encodeXWWWFormURL((String)sb.toString());
        }
        return null;
    }

    public static Map<String, String[]> decodePublicNS(String paramValue) {
        if (!ParameterValidation.isNullOrEmpty((String)paramValue)) {
            String encodedURL = URLTools.decodeXWWWFormURL((String)paramValue);
            HashMap<String, String[]> publicNS = new HashMap<String, String[]>(7);
            boolean finished = false;
            while (encodedURL.length() > 0 && !finished) {
                String param;
                int endParamIndex = encodedURL.indexOf("&");
                if (endParamIndex < 0) {
                    param = encodedURL;
                    finished = true;
                } else {
                    param = encodedURL.substring(0, endParamIndex);
                }
                int equalsIndex = param.indexOf("=");
                if (equalsIndex < 0) {
                    publicNS.put(param, null);
                } else {
                    String name = param.substring(0, equalsIndex);
                    String value = param.substring(equalsIndex + "=".length(), param.length());
                    WSRPUtils.addMultiValuedValueTo(publicNS, name, value);
                }
                encodedURL = encodedURL.substring(endParamIndex + "&".length());
            }
            return publicNS;
        }
        return null;
    }

    public static PropertyAccessor getPropertyAccessor() {
        return propertyAccessor;
    }

    static PropertyAccessor getPropertyAccessor(boolean reload) {
        if (reload) {
            propertyAccessor = new DefaultPropertyAccessor();
        }
        return propertyAccessor;
    }

    public static <T> List<T> replaceByEmptyListIfNeeded(List<T> list) {
        if (WSRPUtils.isSingletonListWithNullOrEmptyElement(list)) {
            return Collections.emptyList();
        }
        return list;
    }

    public static <T> boolean isSingletonListWithNullOrEmptyElement(List<T> list) {
        T element;
        return list.size() == 1 && ((element = list.get(0)) == null || element instanceof String && ((String)element).isEmpty());
    }

    static {
        strict = true;
        log = LoggerFactory.getLogger(WSRPUtils.class);
        propertyAccessor = new DefaultPropertyAccessor();
        JSR168_WSRP_WINDOW_STATES.put(WindowState.MAXIMIZED.toString(), "wsrp:maximized");
        JSR168_WSRP_WINDOW_STATES.put(WindowState.MINIMIZED.toString(), "wsrp:minimized");
        JSR168_WSRP_WINDOW_STATES.put(WindowState.NORMAL.toString(), "wsrp:normal");
        JSR168_WSRP_MODES.put(Mode.EDIT.toString(), "wsrp:edit");
        JSR168_WSRP_MODES.put(Mode.HELP.toString(), "wsrp:help");
        JSR168_WSRP_MODES.put(Mode.VIEW.toString(), "wsrp:view");
        WSRP_JSR168_WINDOW_STATES.put("wsrp:maximized", WindowState.MAXIMIZED);
        WSRP_JSR168_WINDOW_STATES.put("wsrp:minimized", WindowState.MINIMIZED);
        WSRP_JSR168_WINDOW_STATES.put("wsrp:normal", WindowState.NORMAL);
        WSRP_JSR168_MODES.put("wsrp:edit", Mode.EDIT);
        WSRP_JSR168_MODES.put("wsrp:help", Mode.HELP);
        WSRP_JSR168_MODES.put("wsrp:view", Mode.VIEW);
        DEFAULT_JSR168_MODES = new HashSet<Mode>(WSRP_JSR168_MODES.values());
        DEFAULT_JSR168_WINDOWSTATES = new HashSet<WindowState>(WSRP_JSR168_WINDOW_STATES.values());
        JSR286_WSRP_CACHE.put(CacheLevel.FULL, "full");
        JSR286_WSRP_CACHE.put(CacheLevel.PAGE, "page");
        JSR286_WSRP_CACHE.put(CacheLevel.PORTLET, "portlet");
    }

    private static class DefaultPropertyAccessor
    implements PropertyAccessor {
        private boolean urlRewritingActive = !Boolean.parseBoolean(System.getProperty("org.gatein.wsrp.producer.deactivateURLRewriting"));

        private DefaultPropertyAccessor() {
        }

        @Override
        public boolean isURLRewritingActive() {
            return this.urlRewritingActive;
        }
    }

    public static class AbsoluteURLReplacementGenerator
    extends URLTools.URLReplacementGenerator {
        private String serverAddress;

        public AbsoluteURLReplacementGenerator(HttpServletRequest request) {
            this.serverAddress = URLTools.getServerAddressFrom((HttpServletRequest)request);
        }

        public String getReplacementFor(int i, URLTools.URLMatch urlMatch) {
            return this.getAbsoluteURLFor(urlMatch.getURLAsString());
        }

        String getAbsoluteURLFor(String url) {
            return WSRPUtils.getAbsoluteURLFor(url, true, this.serverAddress);
        }
    }
}

