/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.payload;

import java.io.Serializable;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.api.extensions.UnmarshalledExtension;
import org.gatein.wsrp.payload.SerializableNamedStringArray;
import org.gatein.wsrp.payload.SerializablePayload;
import org.gatein.wsrp.payload.SerializableSimplePayload;
import org.gatein.wsrp.payload.XSDTypeConverter;
import org.oasis.wsrp.v2.Event;
import org.oasis.wsrp.v2.EventPayload;
import org.oasis.wsrp.v2.NamedStringArray;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

public class PayloadUtils {
    private static final Map<String, XSDTypeConverter> typeToConverters;
    private static final Map<Class, XSDTypeConverter> classToConverters;
    private static final ThreadLocal<DocumentBuilder> documentBuilder;

    public static Serializable getPayloadAsSerializable(Event event) {
        EventPayload payload = event.getPayload();
        if (payload == null) {
            return null;
        }
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)event, (String)"Payload expected type");
        Object any = payload.getAny();
        if (any == null) {
            NamedStringArray namedStringArray = payload.getNamedStringArray();
            if (namedStringArray != null) {
                return new SerializableNamedStringArray(namedStringArray);
            }
            return null;
        }
        Element element = (Element)any;
        QName type = event.getType();
        if (type != null) {
            String typeName = type.getLocalPart();
            if ("http://www.w3.org/2001/XMLSchema".equals(type.getNamespaceURI())) {
                XSDTypeConverter converter = typeToConverters.get(typeName);
                if (converter == null) {
                    throw new IllegalArgumentException("Don't know how to deal with standard type: " + type);
                }
                return new SerializableSimplePayload(element, converter.parseFromXML(element.getTextContent()), converter);
            }
        }
        return new SerializablePayload(element);
    }

    public static EventPayload getPayloadAsEventPayload(Event eventNeedingType, Serializable payload) {
        if (payload instanceof SerializableNamedStringArray) {
            SerializableNamedStringArray stringArray = (SerializableNamedStringArray)payload;
            return WSRPTypeFactory.createEventPayloadAsNamedString(stringArray.toNamedStringArray());
        }
        if (payload instanceof SerializablePayload) {
            if (payload instanceof SerializableSimplePayload) {
                eventNeedingType.setType(((SerializableSimplePayload)payload).getConverter().getXSDType());
            }
            return WSRPTypeFactory.createEventPayloadAsAny(((SerializablePayload)payload).getElement());
        }
        Class<?> payloadClass = payload.getClass();
        XSDTypeConverter converter = classToConverters.get(payloadClass);
        if (converter != null) {
            eventNeedingType.setType(converter.getXSDType());
        }
        QName name = eventNeedingType.getName();
        try {
            return WSRPTypeFactory.createEventPayloadAsAny(PayloadUtils.marshallPayload(payload, payloadClass, name));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't marshall payload " + payload, e);
        }
    }

    public static Element marshallPayload(Serializable payload) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)payload, (String)"Payload");
        Class<?> payloadClass = payload.getClass();
        XSDTypeConverter converter = classToConverters.get(payloadClass);
        if (converter == null) {
            throw new IllegalArgumentException("Don't know hot to marshall payload " + payload);
        }
        try {
            return PayloadUtils.marshallPayload(payload, payloadClass, converter.getXSDType());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't marshall payload " + payload, e);
        }
    }

    public static Serializable unmarshallPayload(Object object) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)object, (String)"Object to unmarshall");
        if (object instanceof Element) {
            Element element = (Element)object;
            String namespace = element.getNamespaceURI();
            if ("http://www.w3.org/2001/XMLSchema".equals(namespace)) {
                XSDTypeConverter converter;
                TypeInfo type = element.getSchemaTypeInfo();
                String typeName = type.getTypeName();
                if (typeName == null) {
                    String tagName = element.getTagName();
                    int prefixEnd = tagName.indexOf(58);
                    String string = typeName = prefixEnd == -1 ? tagName : tagName.substring(prefixEnd + 1);
                }
                if ((converter = typeToConverters.get(typeName)) == null) {
                    throw new IllegalArgumentException("Don't know how to deal with standard type: " + type);
                }
                return converter.parseFromXML(element.getTextContent());
            }
        } else if (object instanceof Serializable) {
            return (Serializable)object;
        }
        throw new IllegalArgumentException("Cannot unmarshall element with unknown type");
    }

    public static UnmarshalledExtension unmarshallExtension(Object object) {
        if (object instanceof Element) {
            Element element = (Element)object;
            Object value = element;
            String namespace = element.getNamespaceURI();
            String tagName = element.getTagName();
            int prefixEnd = tagName.indexOf(58);
            String string = tagName = prefixEnd == -1 ? tagName : tagName.substring(prefixEnd + 1);
            if ("http://www.w3.org/2001/XMLSchema".equals(namespace)) {
                XSDTypeConverter converter;
                TypeInfo type = element.getSchemaTypeInfo();
                String typeName = type.getTypeName();
                if (typeName == null) {
                    typeName = tagName;
                }
                if ((converter = typeToConverters.get(typeName)) == null) {
                    throw new IllegalArgumentException("Don't know how to deal with standard type: " + type);
                }
                value = converter.parseFromXML(element.getTextContent());
            }
            return new UnmarshalledExtension(tagName, value, namespace);
        }
        throw new IllegalArgumentException("Cannot unmarshall extension '" + object + "'");
    }

    private static Element marshallPayload(Serializable payload, Class payloadClass, QName name) throws JAXBException, ParserConfigurationException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{payloadClass});
        Marshaller marshaller = context.createMarshaller();
        JAXBElement element = new JAXBElement(name, payloadClass, (Object)payload);
        Document document = PayloadUtils.getDocument();
        marshaller.marshal((Object)element, (Node)document);
        return document.getDocumentElement();
    }

    public static Element marshallExtension(Object value) {
        if (value instanceof Element) {
            return (Element)value;
        }
        try {
            return PayloadUtils.marshallPayload((Serializable)value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't marshall extension '" + value + "'");
        }
    }

    private static Document getDocument() {
        return documentBuilder.get().newDocument();
    }

    public static String outputToXML(Element node) {
        Document document = node.getOwnerDocument();
        DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)document.getImplementation());
        LSSerializer serializer = domImplLS.createLSSerializer();
        return serializer.writeToString(node);
    }

    public static Element createElement(String namespaceURI, String name) {
        return PayloadUtils.getDocument().createElementNS(namespaceURI, name);
    }

    public static Element parseFromXMLString(String xml) {
        try {
            return documentBuilder.get().parse(new InputSource(new StringReader(xml))).getDocumentElement();
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't parse '" + xml + "' as a DOM Element.", e);
        }
    }

    static {
        XSDTypeConverter[] converterArray;
        typeToConverters = new HashMap<String, XSDTypeConverter>(19);
        classToConverters = new HashMap<Class, XSDTypeConverter>(19);
        documentBuilder = new ThreadLocal<DocumentBuilder>(){

            @Override
            protected DocumentBuilder initialValue() {
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                builderFactory.setNamespaceAware(true);
                try {
                    return builderFactory.newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    throw new RuntimeException("Couldn't get a DocumentBuilder", e);
                }
            }
        };
        for (XSDTypeConverter converter : converterArray = XSDTypeConverter.values()) {
            typeToConverters.put(converter.typeName(), converter);
            Class javaType = converter.getJavaType();
            if (javaType == null) continue;
            classToConverters.put(javaType, converter);
        }
    }
}

