/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.payload;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import javax.xml.bind.DatatypeConverter;
import javax.xml.namespace.QName;
import org.gatein.wsrp.WSRPConstants;

public enum XSDTypeConverter {
    ANY_SIMPLE_TYPE("anySimpleType"){

        @Override
        public Serializable parseFromXML(String value) {
            return DatatypeConverter.parseAnySimpleType((String)value);
        }

        @Override
        public String printToXML(Serializable value) {
            return DatatypeConverter.printAnySimpleType((String)((String)((Object)value)));
        }

        @Override
        public Class getJavaType() {
            return Object.class;
        }

        @Override
        public QName getXSDType() {
            return WSRPConstants.XSD_ANY_SIMPLE_TYPE;
        }
    }
    ,
    BASE64_BINARY("base64Binary"){

        @Override
        public Serializable parseFromXML(String value) {
            return DatatypeConverter.parseBase64Binary((String)value);
        }

        @Override
        public String printToXML(Serializable value) {
            return DatatypeConverter.printBase64Binary((byte[])((byte[])value));
        }

        @Override
        public Class getJavaType() {
            return byte[].class;
        }

        @Override
        public QName getXSDType() {
            return WSRPConstants.XSD_BASE_64_BINARY;
        }
    }
    ,
    BOOLEAN("boolean"){

        @Override
        public Serializable parseFromXML(String value) {
            return Boolean.valueOf(DatatypeConverter.parseBoolean((String)value));
        }

        @Override
        public String printToXML(Serializable value) {
            return DatatypeConverter.printBoolean((boolean)((Boolean)value));
        }

        @Override
        public Class getJavaType() {
            return Boolean.TYPE;
        }

        @Override
        public QName getXSDType() {
            return WSRPConstants.XSD_BOOLEAN;
        }
    }
    ,
    BYTE("byte"){

        @Override
        public Serializable parseFromXML(String value) {
            return Byte.valueOf(DatatypeConverter.parseByte((String)value));
        }

        @Override
        public String printToXML(Serializable value) {
            return DatatypeConverter.printByte((byte)((Byte)value));
        }

        @Override
        public Class getJavaType() {
            return Byte.TYPE;
        }

        @Override
        public QName getXSDType() {
            return WSRPConstants.XSD_BYTE;
        }
    }
    ,
    DATE("date"){

        @Override
        public Serializable parseFromXML(String value) {
            return DatatypeConverter.parseDate((String)value);
        }

        @Override
        public String printToXML(Serializable value) {
            return DatatypeConverter.printDate((Calendar)((Calendar)value));
        }

        @Override
        public Class getJavaType() {
            return null;
        }

        @Override
        public QName getXSDType() {
            return WSRPConstants.XSD_DATE;
        }
    }
    ,
    DATE_TIME("dateTime"){

        @Override
        public Serializable parseFromXML(String value) {
            return DatatypeConverter.parseDateTime((String)value);
        }

        @Override
        public String printToXML(Serializable value) {
            return DatatypeConverter.printDateTime((Calendar)((Calendar)value));
        }

        @Override
        public Class getJavaType() {
            return Calendar.class;
        }

        @Override
        public QName getXSDType() {
            return WSRPConstants.XSD_DATE_TIME;
        }
    }
    ,
    DECIMAL("decimal"){

        @Override
        public Serializable parseFromXML(String value) {
            return DatatypeConverter.parseDecimal((String)value);
        }

        @Override
        public String printToXML(Serializable value) {
            return DatatypeConverter.printDecimal((BigDecimal)((BigDecimal)value));
        }

        @Override
        public Class getJavaType() {
            return BigDecimal.class;
        }

        @Override
        public QName getXSDType() {
            return WSRPConstants.XSD_DECIMAL;
        }
    }
    ,
    DOUBLE("double"){

        @Override
        public Serializable parseFromXML(String value) {
            return Double.valueOf(DatatypeConverter.parseDouble((String)value));
        }

        @Override
        public String printToXML(Serializable value) {
            return DatatypeConverter.printDouble((double)((Double)value));
        }

        @Override
        public Class getJavaType() {
            return Double.TYPE;
        }

        @Override
        public QName getXSDType() {
            return WSRPConstants.XSD_DOUBLE;
        }
    }
    ,
    FLOAT("float"){

        @Override
        public Serializable parseFromXML(String value) {
            return Float.valueOf(DatatypeConverter.parseFloat((String)value));
        }

        @Override
        public String printToXML(Serializable value) {
            return DatatypeConverter.printFloat((float)((Float)value).floatValue());
        }

        @Override
        public Class getJavaType() {
            return Float.TYPE;
        }

        @Override
        public QName getXSDType() {
            return WSRPConstants.XSD_FLOAT;
        }
    }
    ,
    HEX_BINARY("hexBinary"){

        @Override
        public Serializable parseFromXML(String value) {
            return DatatypeConverter.parseHexBinary((String)value);
        }

        @Override
        public String printToXML(Serializable value) {
            return DatatypeConverter.printHexBinary((byte[])((byte[])value));
        }

        @Override
        public Class getJavaType() {
            return null;
        }

        @Override
        public QName getXSDType() {
            return WSRPConstants.XSD_HEX_BINARY;
        }
    }
    ,
    INT("int"){

        @Override
        public Serializable parseFromXML(String value) {
            return Integer.valueOf(DatatypeConverter.parseInt((String)value));
        }

        @Override
        public String printToXML(Serializable value) {
            return DatatypeConverter.printInt((int)((Integer)value));
        }

        @Override
        public Class getJavaType() {
            return Integer.TYPE;
        }

        @Override
        public QName getXSDType() {
            return WSRPConstants.XSD_INT;
        }
    }
    ,
    INTEGER("integer"){

        @Override
        public Serializable parseFromXML(String value) {
            return DatatypeConverter.parseInteger((String)value);
        }

        @Override
        public String printToXML(Serializable value) {
            return DatatypeConverter.printInteger((BigInteger)((BigInteger)value));
        }

        @Override
        public Class getJavaType() {
            return BigInteger.class;
        }

        @Override
        public QName getXSDType() {
            return WSRPConstants.XSD_INTEGER;
        }
    }
    ,
    LONG("long"){

        @Override
        public Serializable parseFromXML(String value) {
            return Long.valueOf(DatatypeConverter.parseLong((String)value));
        }

        @Override
        public String printToXML(Serializable value) {
            return DatatypeConverter.printLong((long)((Long)value));
        }

        @Override
        public Class getJavaType() {
            return Long.TYPE;
        }

        @Override
        public QName getXSDType() {
            return WSRPConstants.XSD_LONG;
        }
    }
    ,
    SHORT("short"){

        @Override
        public Serializable parseFromXML(String value) {
            return Short.valueOf(DatatypeConverter.parseShort((String)value));
        }

        @Override
        public String printToXML(Serializable value) {
            return DatatypeConverter.printShort((short)((Short)value));
        }

        @Override
        public Class getJavaType() {
            return Short.TYPE;
        }

        @Override
        public QName getXSDType() {
            return WSRPConstants.XSD_SHORT;
        }
    }
    ,
    STRING("string"){

        @Override
        public Serializable parseFromXML(String value) {
            return DatatypeConverter.parseString((String)value);
        }

        @Override
        public String printToXML(Serializable value) {
            return DatatypeConverter.printString((String)((String)((Object)value)));
        }

        @Override
        public Class getJavaType() {
            return String.class;
        }

        @Override
        public QName getXSDType() {
            return WSRPConstants.XSD_STRING;
        }
    }
    ,
    TIME("time"){

        @Override
        public Serializable parseFromXML(String value) {
            return DatatypeConverter.parseTime((String)value);
        }

        @Override
        public String printToXML(Serializable value) {
            return DatatypeConverter.printTime((Calendar)((Calendar)value));
        }

        @Override
        public Class getJavaType() {
            return null;
        }

        @Override
        public QName getXSDType() {
            return WSRPConstants.XSD_TIME;
        }
    }
    ,
    UNSIGNED_INT("unsignedInt"){

        @Override
        public Serializable parseFromXML(String value) {
            return Long.valueOf(DatatypeConverter.parseUnsignedInt((String)value));
        }

        @Override
        public String printToXML(Serializable value) {
            return DatatypeConverter.printUnsignedInt((long)((Long)value));
        }

        @Override
        public Class getJavaType() {
            return null;
        }

        @Override
        public QName getXSDType() {
            return WSRPConstants.XSD_UNSIGNED_INT;
        }
    }
    ,
    UNSIGNED_SHORT("unsignedShort"){

        @Override
        public Serializable parseFromXML(String value) {
            return Integer.valueOf(DatatypeConverter.parseUnsignedShort((String)value));
        }

        @Override
        public String printToXML(Serializable value) {
            return DatatypeConverter.printUnsignedShort((int)((Integer)value));
        }

        @Override
        public Class getJavaType() {
            return null;
        }

        @Override
        public QName getXSDType() {
            return WSRPConstants.XSD_UNSIGNED_SHORT;
        }
    };

    private String typeName;

    private XSDTypeConverter(String typeName) {
        this.typeName = typeName;
    }

    public String typeName() {
        return this.typeName;
    }

    public abstract Serializable parseFromXML(String var1);

    public abstract String printToXML(Serializable var1);

    public abstract Class getJavaType();

    public abstract QName getXSDType();
}

