/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jws.WebParam;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import junit.framework.TestCase;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.wsrp.consumer.EndpointConfigurationInfo;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.consumer.RegistrationInfo;
import org.gatein.wsrp.consumer.RegistrationProperty;
import org.gatein.wsrp.consumer.spi.ConsumerRegistrySPI;
import org.gatein.wsrp.services.ServiceFactory;
import org.gatein.wsrp.spec.v2.WSRP2ExceptionFactory;
import org.gatein.wsrp.test.protocol.v2.BehaviorBackedServiceFactory;
import org.gatein.wsrp.test.protocol.v2.PortletManagementBehavior;
import org.gatein.wsrp.test.protocol.v2.RegistrationBehavior;
import org.gatein.wsrp.test.protocol.v2.ServiceDescriptionBehavior;
import org.gatein.wsrp.test.protocol.v2.behaviors.GroupedPortletsServiceDescriptionBehavior;
import org.gatein.wsrp.test.protocol.v2.behaviors.SupportedOptionsServiceDescriptionBehavior;
import org.gatein.wsrp.test.support.MockConsumerRegistry;
import org.oasis.wsrp.v2.AccessDenied;
import org.oasis.wsrp.v2.CookieProtocol;
import org.oasis.wsrp.v2.Extension;
import org.oasis.wsrp.v2.InconsistentParameters;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.InvalidUserCategory;
import org.oasis.wsrp.v2.Lifetime;
import org.oasis.wsrp.v2.MissingParameters;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.OperationNotSupported;
import org.oasis.wsrp.v2.PortletContext;
import org.oasis.wsrp.v2.PortletDescription;
import org.oasis.wsrp.v2.Property;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.RegistrationData;
import org.oasis.wsrp.v2.ResourceList;
import org.oasis.wsrp.v2.ResourceSuspended;
import org.oasis.wsrp.v2.UserContext;

public class ProducerInfoTestCase
extends TestCase {
    private ProducerInfo info;
    private BehaviorBackedServiceFactory serviceFactory;

    protected void setUp() throws Exception {
        this.info = new ProducerInfo((ConsumerRegistrySPI)new MockConsumerRegistry());
        this.info.setId("test");
        this.info.setKey("key");
        this.serviceFactory = new BehaviorBackedServiceFactory();
        EndpointConfigurationInfo eci = new EndpointConfigurationInfo((ServiceFactory)this.serviceFactory);
        this.info.setEndpointConfigurationInfo(eci);
    }

    public void testSetRegistrationInfo() {
        RegistrationInfo regInfo = new RegistrationInfo(this.info);
        ProducerInfoTestCase.assertEquals((Object)regInfo, (Object)this.info.getRegistrationInfo());
        ProducerInfoTestCase.assertEquals((Object)this.info, (Object)regInfo.getParent());
        RegistrationInfo regInfo2 = new RegistrationInfo();
        ProducerInfoTestCase.assertEquals((Object)regInfo, (Object)this.info.getRegistrationInfo());
        ProducerInfoTestCase.assertNull((Object)regInfo2.getParent());
        this.info.setRegistrationInfo(regInfo2);
        ProducerInfoTestCase.assertEquals((Object)regInfo2, (Object)this.info.getRegistrationInfo());
        ProducerInfoTestCase.assertEquals((Object)this.info, (Object)regInfo2.getParent());
    }

    public void testRefreshDidNotHappenIfFailure() throws PortletInvokerException {
        this.serviceFactory.setFailed(true);
        boolean refresh = this.info.refresh(false);
        ProducerInfoTestCase.assertFalse((boolean)refresh);
    }

    public void testSetNullRegistrationInfo() {
        try {
            this.info.setRegistrationInfo(null);
            ProducerInfoTestCase.fail((String)"Shouldn't be possible to set a null RegistrationInfo");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetEndpointConfigurationInfo() {
        EndpointConfigurationInfo endInfo = new EndpointConfigurationInfo();
        this.info.setEndpointConfigurationInfo(endInfo);
        ProducerInfoTestCase.assertEquals((Object)endInfo, (Object)this.info.getEndpointConfigurationInfo());
    }

    public void testSetNullEndpointConfigurationInfo() {
        try {
            this.info.setEndpointConfigurationInfo(null);
            ProducerInfoTestCase.fail((String)"Shouldn't be possible to set a null EndpointConfigurationInfo");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetNullCache() throws PortletInvokerException {
        ServiceDescriptionBehavior behavior = new ServiceDescriptionBehavior();
        this.serviceFactory.getRegistry().setServiceDescriptionBehavior(behavior);
        ProducerInfoTestCase.assertEquals((Object)ProducerInfo.DEFAULT_CACHE_VALUE, (Object)this.info.getExpirationCacheSeconds());
        this.info.setExpirationCacheSeconds(null);
        ProducerInfoTestCase.assertNull((Object)this.info.getExpirationCacheSeconds());
        ProducerInfoTestCase.assertTrue((boolean)this.info.isRefreshNeeded(false));
        ProducerInfoTestCase.assertFalse((boolean)this.info.isRegistrationChecked());
        ProducerInfoTestCase.assertTrue((boolean)this.info.refresh(false));
        ProducerInfoTestCase.assertFalse((boolean)this.info.isRefreshNeeded(false));
        ProducerInfoTestCase.assertTrue((boolean)this.info.isRegistrationChecked());
        ProducerInfoTestCase.assertTrue((boolean)this.info.refresh(false));
        ProducerInfoTestCase.assertFalse((boolean)this.info.isRefreshNeeded(false));
        ProducerInfoTestCase.assertTrue((boolean)this.info.isRegistrationChecked());
        ProducerInfoTestCase.assertEquals((int)2, (int)behavior.getCallCount());
    }

    public void testSetNegativeCache() throws PortletInvokerException {
        ServiceDescriptionBehavior behavior = new ServiceDescriptionBehavior();
        this.serviceFactory.getRegistry().setServiceDescriptionBehavior(behavior);
        ProducerInfoTestCase.assertEquals((Object)ProducerInfo.DEFAULT_CACHE_VALUE, (Object)this.info.getExpirationCacheSeconds());
        this.info.setExpirationCacheSeconds(Integer.valueOf(-100));
        ProducerInfoTestCase.assertEquals((Object)new Integer(-100), (Object)this.info.getExpirationCacheSeconds());
        ProducerInfoTestCase.assertTrue((boolean)this.info.isRefreshNeeded(false));
        ProducerInfoTestCase.assertFalse((boolean)this.info.isRegistrationChecked());
        ProducerInfoTestCase.assertTrue((boolean)this.info.refresh(false));
        ProducerInfoTestCase.assertFalse((boolean)this.info.isRefreshNeeded(false));
        ProducerInfoTestCase.assertTrue((boolean)this.info.isRegistrationChecked());
        ProducerInfoTestCase.assertTrue((boolean)this.info.refresh(false));
        ProducerInfoTestCase.assertFalse((boolean)this.info.isRefreshNeeded(false));
        ProducerInfoTestCase.assertTrue((boolean)this.info.isRegistrationChecked());
        ProducerInfoTestCase.assertEquals((int)2, (int)behavior.getCallCount());
    }

    public void testSetZeroCache() throws PortletInvokerException {
        ServiceDescriptionBehavior behavior = new ServiceDescriptionBehavior();
        this.serviceFactory.getRegistry().setServiceDescriptionBehavior(behavior);
        ProducerInfoTestCase.assertEquals((Object)ProducerInfo.DEFAULT_CACHE_VALUE, (Object)this.info.getExpirationCacheSeconds());
        this.info.setExpirationCacheSeconds(Integer.valueOf(0));
        ProducerInfoTestCase.assertEquals((Object)new Integer(0), (Object)this.info.getExpirationCacheSeconds());
        ProducerInfoTestCase.assertTrue((boolean)this.info.isRefreshNeeded(false));
        ProducerInfoTestCase.assertFalse((boolean)this.info.isRegistrationChecked());
        ProducerInfoTestCase.assertTrue((boolean)this.info.refresh(false));
        ProducerInfoTestCase.assertFalse((boolean)this.info.isRefreshNeeded(false));
        ProducerInfoTestCase.assertTrue((boolean)this.info.isRegistrationChecked());
        ProducerInfoTestCase.assertTrue((boolean)this.info.refresh(false));
        ProducerInfoTestCase.assertFalse((boolean)this.info.isRefreshNeeded(false));
        ProducerInfoTestCase.assertTrue((boolean)this.info.isRegistrationChecked());
        ProducerInfoTestCase.assertEquals((int)2, (int)behavior.getCallCount());
    }

    public void testCacheTransitions() throws Exception {
        ServiceDescriptionBehavior behavior = new ServiceDescriptionBehavior();
        this.serviceFactory.getRegistry().setServiceDescriptionBehavior(behavior);
        ProducerInfoTestCase.assertEquals((Object)ProducerInfo.DEFAULT_CACHE_VALUE, (Object)this.info.getExpirationCacheSeconds());
        this.info.setExpirationCacheSeconds(null);
        ProducerInfoTestCase.assertNull((Object)this.info.getExpirationCacheSeconds());
        ProducerInfoTestCase.assertTrue((boolean)this.info.isRefreshNeeded(false));
        ProducerInfoTestCase.assertFalse((boolean)this.info.isRegistrationChecked());
        ProducerInfoTestCase.assertTrue((boolean)this.info.refresh(false));
        ProducerInfoTestCase.assertFalse((boolean)this.info.isRefreshNeeded(false));
        ProducerInfoTestCase.assertTrue((boolean)this.info.isRegistrationChecked());
        ProducerInfoTestCase.assertTrue((boolean)this.info.refresh(false));
        ProducerInfoTestCase.assertFalse((boolean)this.info.isRefreshNeeded(false));
        ProducerInfoTestCase.assertTrue((boolean)this.info.isRegistrationChecked());
        ProducerInfoTestCase.assertEquals((int)2, (int)behavior.getCallCount());
        Thread.sleep(10L);
        this.info.setExpirationCacheSeconds(Integer.valueOf(1));
        ProducerInfoTestCase.assertEquals((Object)new Integer(1), (Object)this.info.getExpirationCacheSeconds());
        ProducerInfoTestCase.assertFalse((String)"we refreshed less than a second ago so we don't need to refresh again", (boolean)this.info.refresh(false));
        ProducerInfoTestCase.assertFalse((boolean)this.info.isRefreshNeeded(false));
        ProducerInfoTestCase.assertTrue((boolean)this.info.isRegistrationChecked());
        ProducerInfoTestCase.assertEquals((int)2, (int)behavior.getCallCount());
        Thread.sleep(1100L);
        ProducerInfoTestCase.assertFalse((String)"refresh is not needed if cache is not considered", (boolean)this.info.isRefreshNeeded(false));
        ProducerInfoTestCase.assertTrue((String)"refresh is needed if cache is considered since it has expired", (boolean)this.info.isRefreshNeeded(true));
        ProducerInfoTestCase.assertTrue((boolean)this.info.refresh(false));
        ProducerInfoTestCase.assertFalse((String)"Was just refreshed so refresh is not needed even considering cache", (boolean)this.info.isRefreshNeeded(true));
        ProducerInfoTestCase.assertTrue((boolean)this.info.isRegistrationChecked());
        ProducerInfoTestCase.assertFalse((boolean)this.info.refresh(false));
        ProducerInfoTestCase.assertTrue((boolean)this.info.refresh(true));
        ProducerInfoTestCase.assertFalse((boolean)this.info.isRefreshNeeded(false));
        ProducerInfoTestCase.assertTrue((boolean)this.info.isRegistrationChecked());
        ProducerInfoTestCase.assertEquals((int)4, (int)behavior.getCallCount());
        Thread.sleep(10L);
        this.info.setExpirationCacheSeconds(Integer.valueOf(0));
        ProducerInfoTestCase.assertEquals((Object)new Integer(0), (Object)this.info.getExpirationCacheSeconds());
        ProducerInfoTestCase.assertTrue((boolean)this.info.refresh(false));
        ProducerInfoTestCase.assertTrue((boolean)this.info.refresh(false));
        ProducerInfoTestCase.assertFalse((String)"since we've been refreshed at least once before, refreshing the endpoint and registration has been done so refresh is not needed", (boolean)this.info.isRefreshNeeded(false));
        ProducerInfoTestCase.assertTrue((boolean)this.info.isRefreshNeeded(true));
        ProducerInfoTestCase.assertTrue((boolean)this.info.isRegistrationChecked());
        ProducerInfoTestCase.assertEquals((int)6, (int)behavior.getCallCount());
    }

    public void testGetPortlet() throws Exception {
        ServiceDescriptionBehavior behavior = new ServiceDescriptionBehavior();
        behavior.addPortletDescription(behavior.createPortletDescription("test", null));
        this.serviceFactory.getRegistry().setServiceDescriptionBehavior(behavior);
        this.info.setExpirationCacheSeconds(Integer.valueOf(1000));
        org.gatein.pc.api.PortletContext portletContext = org.gatein.pc.api.PortletContext.createPortletContext((String)"test", (boolean)false);
        Portlet portlet = this.info.getPortlet(portletContext);
        ProducerInfoTestCase.assertNotNull((Object)portlet);
        ProducerInfoTestCase.assertEquals((Object)portletContext, (Object)portlet.getContext());
        ProducerInfoTestCase.assertEquals((int)1, (int)behavior.getCallCount());
        portletContext = org.gatein.pc.api.PortletContext.createPortletContext((String)"test2", (boolean)false);
        TestPortletManagementBehavior pmBehavior = new TestPortletManagementBehavior();
        this.serviceFactory.getRegistry().setPortletManagementBehavior(pmBehavior);
        portlet = this.info.getPortlet(portletContext);
        ProducerInfoTestCase.assertEquals((int)1, (int)pmBehavior.getCallCount());
        ProducerInfoTestCase.assertNotNull((Object)portlet);
        ProducerInfoTestCase.assertEquals((Object)portletContext, (Object)portlet.getContext());
        this.serviceFactory.getRegistry().setPortletManagementBehavior(null);
        String handle = "test3";
        behavior.addPortletDescription(behavior.createPortletDescription("test3", null));
        portletContext = org.gatein.pc.api.PortletContext.createPortletContext((String)"test3", (boolean)false);
        portlet = this.info.getPortlet(portletContext);
        ProducerInfoTestCase.assertEquals((int)2, (int)behavior.getCallCount());
        ProducerInfoTestCase.assertNotNull((Object)portlet);
        ProducerInfoTestCase.assertEquals((Object)portletContext, (Object)portlet.getContext());
    }

    public void testRefreshAndRegistration() throws Exception {
        ProducerInfoTestCase.assertFalse((boolean)this.info.isRegistered());
        RegistrationInfo regInfo = this.info.getRegistrationInfo();
        ProducerInfoTestCase.assertTrue((boolean)regInfo.isUndetermined());
        ServiceDescriptionBehavior sd = new ServiceDescriptionBehavior();
        sd.setRequiresRegistration(true);
        this.serviceFactory.getRegistry().setServiceDescriptionBehavior(sd);
        RegistrationBehavior regBehavior = new RegistrationBehavior();
        this.serviceFactory.getRegistry().setRegistrationBehavior(regBehavior);
        ProducerInfoTestCase.assertTrue((boolean)this.info.refresh(false));
        ProducerInfoTestCase.assertEquals((int)1, (int)regBehavior.getCallCount());
        ProducerInfoTestCase.assertTrue((boolean)this.info.isRegistered());
        ProducerInfoTestCase.assertNotNull((Object)this.info.getRegistrationInfo());
        ProducerInfoTestCase.assertEquals((String)"registration", (String)this.info.getRegistrationContext().getRegistrationHandle());
        ProducerInfoTestCase.assertTrue((boolean)this.info.refresh(true));
        ProducerInfoTestCase.assertEquals((int)1, (int)regBehavior.getCallCount());
    }

    public void testGetRegistrationContext() throws Exception {
        ProducerInfoTestCase.assertFalse((boolean)this.info.isRegistered());
        RegistrationInfo regInfo = this.info.getRegistrationInfo();
        ProducerInfoTestCase.assertTrue((boolean)regInfo.isUndetermined());
        ServiceDescriptionBehavior sd = new ServiceDescriptionBehavior();
        sd.setRequiresRegistration(true);
        this.serviceFactory.getRegistry().setServiceDescriptionBehavior(sd);
        RegistrationBehavior regBehavior = new RegistrationBehavior();
        this.serviceFactory.getRegistry().setRegistrationBehavior(regBehavior);
        RegistrationContext registrationContext = this.info.getRegistrationContext();
        ProducerInfoTestCase.assertNotNull((Object)registrationContext);
        ProducerInfoTestCase.assertEquals((String)"registration", (String)registrationContext.getRegistrationHandle());
        ProducerInfoTestCase.assertEquals((String)"Registration should have occured", (int)1, (int)regBehavior.getCallCount());
        ProducerInfoTestCase.assertEquals((String)"Service description should have been called once unregistered and once registered", (int)2, (int)sd.getCallCount());
    }

    public void testRegister() throws Exception {
        ServiceDescriptionBehavior sd = new ServiceDescriptionBehavior();
        sd.setServiceDescription(true, 1);
        this.serviceFactory.getRegistry().setServiceDescriptionBehavior(sd);
        TestRegistrationBehavior regBehavior = new TestRegistrationBehavior();
        this.serviceFactory.getRegistry().setRegistrationBehavior(regBehavior);
        try {
            this.info.register();
            ProducerInfoTestCase.fail((String)"Shouldn't register with invalid information");
        }
        catch (PortletInvokerException expected) {
            // empty catch block
        }
        RegistrationInfo regInfo = this.info.getRegistrationInfo();
        regInfo.setRegistrationPropertyValue(TestRegistrationBehavior.PROP_NAME, "value");
        this.info.register();
        RegistrationContext registrationContext = this.info.getRegistrationContext();
        ProducerInfoTestCase.assertNotNull((Object)registrationContext);
        ProducerInfoTestCase.assertEquals((String)"registration", (String)registrationContext.getRegistrationHandle());
        ProducerInfoTestCase.assertTrue((boolean)this.info.isRegistered());
        ProducerInfoTestCase.assertTrue((boolean)this.info.isRegistrationChecked());
        ProducerInfoTestCase.assertTrue((boolean)this.info.isRegistrationRequired());
    }

    public void testDeregister() throws Exception {
        try {
            this.info.deregister();
            ProducerInfoTestCase.fail((String)"Shouldn't be able to deregister without being registered");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.register();
        this.info.deregister();
        ProducerInfoTestCase.assertNull((Object)this.info.getRegistrationContext());
        ProducerInfoTestCase.assertFalse((boolean)this.info.isRegistered());
        ProducerInfoTestCase.assertTrue((boolean)this.info.isRegistrationRequired());
        ProducerInfoTestCase.assertTrue((boolean)this.info.isRegistrationChecked());
    }

    private void register() throws PortletInvokerException {
        ServiceDescriptionBehavior sd = new ServiceDescriptionBehavior();
        sd.setServiceDescription(true, 1);
        this.serviceFactory.getRegistry().setServiceDescriptionBehavior(sd);
        TestRegistrationBehavior regBehavior = new TestRegistrationBehavior();
        this.serviceFactory.getRegistry().setRegistrationBehavior(regBehavior);
        this.info.refresh(false);
        RegistrationInfo regInfo = this.info.getRegistrationInfo();
        regInfo.setRegistrationPropertyValue(TestRegistrationBehavior.PROP_NAME, "value");
        this.info.register();
    }

    public void testModifyRegistration() throws Exception {
        try {
            this.info.modifyRegistration();
            ProducerInfoTestCase.fail((String)"Shouldn't be able to modify registration without being registered");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        this.register();
        RegistrationInfo regInfo = this.info.getRegistrationInfo();
        regInfo.setRegistrationPropertyValue(TestRegistrationBehavior.PROP_NAME, "invalid");
        ProducerInfoTestCase.assertTrue((boolean)this.info.isRefreshNeeded(false));
        ProducerInfoTestCase.assertTrue((boolean)this.info.isRegistered());
        ProducerInfoTestCase.assertTrue((boolean)this.info.isModifyRegistrationRequired());
        RegistrationProperty prop = regInfo.getRegistrationProperty(TestRegistrationBehavior.PROP_NAME);
        ProducerInfoTestCase.assertNull((Object)prop.isInvalid());
        try {
            this.info.modifyRegistration();
            ProducerInfoTestCase.fail((String)"invalid value for property should fail to modify registration");
        }
        catch (PortletInvokerException expected) {
            // empty catch block
        }
        regInfo.setRegistrationPropertyValue(TestRegistrationBehavior.PROP_NAME, "value2");
        ProducerInfoTestCase.assertTrue((boolean)this.info.isRefreshNeeded(false));
        ProducerInfoTestCase.assertNull((Object)prop.isInvalid());
        ProducerInfoTestCase.assertTrue((boolean)this.info.isModifyRegistrationRequired());
        this.info.modifyRegistration();
        ProducerInfoTestCase.assertTrue((boolean)this.info.isRefreshNeeded(true));
        ProducerInfoTestCase.assertFalse((boolean)this.info.isRefreshNeeded(false));
        ProducerInfoTestCase.assertTrue((boolean)this.info.refresh(false));
        ProducerInfoTestCase.assertFalse((boolean)this.info.isModifyRegistrationRequired());
        Boolean invalid = prop.isInvalid();
        ProducerInfoTestCase.assertNotNull((Object)invalid);
        ProducerInfoTestCase.assertFalse((boolean)invalid);
    }

    public void testGetInfoForEvent() {
        ProducerInfoTestCase.assertNull((Object)this.info.getInfoForEvent(null));
    }

    public void testRequiresInitCookieIsProperlySet() throws PortletInvokerException {
        GroupedPortletsServiceDescriptionBehavior sdb = new GroupedPortletsServiceDescriptionBehavior(new ArrayList<PortletDescription>(3));
        sdb.setRequiresInitCookie(CookieProtocol.PER_GROUP);
        this.serviceFactory.getRegistry().setServiceDescriptionBehavior(sdb);
        this.info.refresh(false);
        ProducerInfoTestCase.assertEquals((Object)CookieProtocol.PER_GROUP, (Object)this.info.getRequiresInitCookie());
    }

    public void testSupportedOptions() throws PortletInvokerException {
        SupportedOptionsServiceDescriptionBehavior sdb = new SupportedOptionsServiceDescriptionBehavior();
        this.serviceFactory.getRegistry().setServiceDescriptionBehavior(sdb);
        this.info.refresh(false);
        Collection supportedOptions = this.info.getSupportedOptions();
        ProducerInfoTestCase.assertEquals((int)2, (int)supportedOptions.size());
        ProducerInfoTestCase.assertTrue((boolean)supportedOptions.contains("wsrp:export"));
        ProducerInfoTestCase.assertTrue((boolean)supportedOptions.contains("wsrp:import"));
    }

    private static class TestRegistrationBehavior
    extends RegistrationBehavior {
        private static final QName PROP_NAME = QName.valueOf("prop0");
        private static final String MODIFIED_VALUE = "value2";
        private static final String ORIGINAL_VALUE = "value";

        private TestRegistrationBehavior() {
        }

        @Override
        public void register(@WebParam(name="registrationData", targetNamespace="urn:oasis:names:tc:wsrp:v2:types") RegistrationData registrationData, @WebParam(name="lifetime", targetNamespace="urn:oasis:names:tc:wsrp:v2:types") Lifetime lifetime, @WebParam(name="userContext", targetNamespace="urn:oasis:names:tc:wsrp:v2:types") UserContext userContext, @WebParam(name="registrationState", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<byte[]> registrationState, @WebParam(name="scheduledDestruction", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<Lifetime> scheduledDestruction, @WebParam(name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<List<Extension>> extensions, @WebParam(name="registrationHandle", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<String> registrationHandle) throws MissingParameters, OperationFailed, OperationNotSupported {
            Property prop = this.checkRegistrationData(registrationData.getRegistrationProperties());
            String value = prop.getStringValue();
            if (ORIGINAL_VALUE.equals(value) && PROP_NAME.equals(prop.getName())) {
                super.register(registrationData, lifetime, userContext, registrationState, scheduledDestruction, extensions, registrationHandle);
                return;
            }
            throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)(value + " is not a valid value for " + PROP_NAME), null);
        }

        @Override
        public void modifyRegistration(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v2:types") RegistrationContext registrationContext, @WebParam(name="registrationData", targetNamespace="urn:oasis:names:tc:wsrp:v2:types") RegistrationData registrationData, @WebParam(name="userContext", targetNamespace="urn:oasis:names:tc:wsrp:v2:types") UserContext userContext, @WebParam(name="registrationState", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<byte[]> registrationState, @WebParam(name="scheduledDestruction", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<Lifetime> scheduledDestruction, @WebParam(name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<List<Extension>> extensions) throws InvalidRegistration, MissingParameters, OperationFailed, OperationNotSupported, ResourceSuspended {
            this.incrementCallCount();
            WSRP2ExceptionFactory.throwMissingParametersIfValueIsMissing((Object)registrationContext, (String)"RegistrationContext", null);
            if (!"registration".equals(registrationContext.getRegistrationHandle())) {
                WSRP2ExceptionFactory.throwWSException(InvalidRegistration.class, (String)"Invalid registration", null);
            }
            WSRP2ExceptionFactory.throwMissingParametersIfValueIsMissing((Object)registrationData, (String)"RegistrationData", null);
            Property prop = this.checkRegistrationData(registrationData.getRegistrationProperties());
            String value = prop.getStringValue();
            if (MODIFIED_VALUE.equals(value) && PROP_NAME.equals(prop.getName())) {
                return;
            }
            throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)(value + " is not a valid value for " + PROP_NAME), null);
        }

        private Property checkRegistrationData(List<Property> registrationProperties) throws OperationFailed {
            WSRP2ExceptionFactory.throwOperationFailedIfValueIsMissing(registrationProperties, (String)"RegistrationData");
            Property prop = registrationProperties.get(0);
            WSRP2ExceptionFactory.throwOperationFailedIfValueIsMissing((Object)prop, (String)"Registration property");
            return prop;
        }
    }

    private static class TestPortletManagementBehavior
    extends PortletManagementBehavior {
        public static final String HANDLE_FOR_GET_DESCRIPTION = "test2";

        private TestPortletManagementBehavior() {
        }

        @Override
        public void getPortletDescription(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v2:types") RegistrationContext registrationContext, @WebParam(name="portletContext", targetNamespace="urn:oasis:names:tc:wsrp:v2:types") PortletContext portletContext, @WebParam(name="userContext", targetNamespace="urn:oasis:names:tc:wsrp:v2:types") UserContext userContext, @WebParam(name="desiredLocales", targetNamespace="urn:oasis:names:tc:wsrp:v2:types") List<String> desiredLocales, @WebParam(name="portletDescription", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<PortletDescription> portletDescription, @WebParam(name="resourceList", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<ResourceList> resourceList, @WebParam(name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<List<Extension>> extensions) throws AccessDenied, InconsistentParameters, InvalidHandle, InvalidRegistration, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
            super.getPortletDescription(registrationContext, portletContext, userContext, desiredLocales, portletDescription, resourceList, extensions);
            portletDescription.value = this.createPortletDescription(HANDLE_FOR_GET_DESCRIPTION, null);
        }
    }
}

