/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer;

import javax.xml.namespace.QName;
import junit.framework.TestCase;
import org.gatein.wsrp.consumer.RegistrationProperty;

public class RegistrationPropertyTestCase
extends TestCase {
    private RegistrationProperty prop;
    private Listener listener = new Listener();
    private static final String VALUE = "value";
    private static final String NEW_VALUE = "newValue";

    protected void setUp() throws Exception {
        this.prop = new RegistrationProperty("name", VALUE, "en", (RegistrationProperty.PropertyChangeListener)this.listener);
    }

    public void testConstructor() {
        try {
            new RegistrationProperty((String)null, VALUE, "en", (RegistrationProperty.PropertyChangeListener)this.listener);
            RegistrationPropertyTestCase.fail((String)"Should have failed on null name");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            new RegistrationProperty("name", null, "en", (RegistrationProperty.PropertyChangeListener)this.listener);
        }
        catch (Exception e) {
            RegistrationPropertyTestCase.fail((String)"Shouldn't have failed on null value");
        }
        try {
            new RegistrationProperty("name", VALUE, null, (RegistrationProperty.PropertyChangeListener)this.listener);
            RegistrationPropertyTestCase.fail((String)"Should have failed on null lang");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            new RegistrationProperty("name", VALUE, "en", null);
            RegistrationPropertyTestCase.fail((String)"Should have failed on null listener");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testSetNullValue() {
        this.forceValid();
        this.prop.setValue(null);
        RegistrationPropertyTestCase.assertNull((Object)this.prop.getValue());
        RegistrationPropertyTestCase.assertTrue((boolean)this.prop.isInvalid());
        RegistrationPropertyTestCase.assertTrue((boolean)this.prop.isDeterminedInvalid());
        RegistrationPropertyTestCase.assertEquals((Object)RegistrationProperty.Status.MISSING_VALUE, (Object)this.prop.getStatus());
    }

    public void testGetters() {
        RegistrationPropertyTestCase.assertEquals((Object)QName.valueOf("name"), (Object)this.prop.getName());
        RegistrationPropertyTestCase.assertEquals((String)VALUE, (String)this.prop.getValue());
        RegistrationPropertyTestCase.assertEquals((String)"en", (String)this.prop.getLang());
        RegistrationPropertyTestCase.assertNull((Object)this.prop.isInvalid());
        RegistrationPropertyTestCase.assertFalse((boolean)this.prop.isDeterminedInvalid());
        RegistrationPropertyTestCase.assertNull((Object)this.prop.getDescription());
        RegistrationPropertyTestCase.assertEquals((Object)RegistrationProperty.Status.UNCHECKED_VALUE, (Object)this.prop.getStatus());
    }

    public void testSetValue() {
        this.forceValid();
        this.prop.setValue(VALUE);
        RegistrationPropertyTestCase.assertEquals((Object)Boolean.FALSE, (Object)this.prop.isInvalid());
        RegistrationPropertyTestCase.assertEquals((Object)RegistrationProperty.Status.VALID, (Object)this.prop.getStatus());
        this.prop.setValue(NEW_VALUE);
        RegistrationPropertyTestCase.assertEquals((String)NEW_VALUE, (String)this.prop.getValue());
        RegistrationPropertyTestCase.assertNull((Object)this.prop.isInvalid());
        RegistrationPropertyTestCase.assertEquals((Object)RegistrationProperty.Status.UNCHECKED_VALUE, (Object)this.prop.getStatus());
    }

    private void forceValid() {
        this.prop.setStatus(RegistrationProperty.Status.VALID);
    }

    public void testPropertyChangedEvent() {
        this.prop.setValue(VALUE);
        RegistrationPropertyTestCase.assertFalse((boolean)this.listener.called);
        this.prop.setValue(NEW_VALUE);
        RegistrationPropertyTestCase.assertTrue((boolean)this.listener.called);
    }

    private class Listener
    implements RegistrationProperty.PropertyChangeListener {
        boolean called;

        private Listener() {
        }

        public void propertyValueChanged(RegistrationProperty property, RegistrationProperty.Status previousStatus, Object oldValue, Object newValue) {
            this.called = RegistrationPropertyTestCase.this.prop == property && RegistrationPropertyTestCase.VALUE.equals(oldValue) && RegistrationPropertyTestCase.NEW_VALUE.equals(newValue);
        }
    }
}

