/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.handler;

import javax.xml.soap.MimeHeaders;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import junit.framework.TestCase;
import org.apache.commons.httpclient.Cookie;
import org.gatein.wsrp.consumer.handlers.ProducerSessionInformation;
import org.gatein.wsrp.handler.RequestHeaderClientHandler;
import org.gatein.wsrp.test.handler.MockSOAPMessage;
import org.gatein.wsrp.test.handler.MockSOAPMessageContext;

public class RequestHeaderClientHandlerTestCase
extends TestCase {
    RequestHeaderClientHandler handler;

    protected void setUp() throws Exception {
        this.handler = new RequestHeaderClientHandler();
        RequestHeaderClientHandler.resetCurrentInfo();
    }

    public void testSimpleCookieHandleRequest() {
        MockSOAPMessage message = new MockSOAPMessage();
        SOAPMessageContext msgContext = MockSOAPMessageContext.createMessageContext((MockSOAPMessage)message, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.handler.handleRequest(msgContext);
        MimeHeaders headers = message.getMimeHeaders();
        RequestHeaderClientHandlerTestCase.assertNull((Object)headers.getHeader("Cookie"));
        ProducerSessionInformation sessionInformation = new ProducerSessionInformation();
        sessionInformation.setUserCookie(new Cookie[]{this.createCookie("name", "value", 1)});
        RequestHeaderClientHandler.setCurrentInfo(null, (ProducerSessionInformation)sessionInformation);
        this.handler.handleRequest(msgContext);
        headers = message.getMimeHeaders();
        String[] cookie = headers.getHeader("Cookie");
        RequestHeaderClientHandlerTestCase.assertEquals((int)1, (int)cookie.length);
        RequestHeaderClientHandlerTestCase.assertEquals((String)"name=value", (String)cookie[0]);
    }

    public void testGroupCookieHandleRequest() {
        MockSOAPMessage message = new MockSOAPMessage();
        SOAPMessageContext msgContext = MockSOAPMessageContext.createMessageContext((MockSOAPMessage)message, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        ProducerSessionInformation info = new ProducerSessionInformation();
        info.setPerGroupCookies(true);
        String groupId = "group";
        info.setGroupCookieFor(groupId, new Cookie[]{this.createCookie("name", "value", 1)});
        RequestHeaderClientHandler.setCurrentInfo(null, (ProducerSessionInformation)info);
        try {
            this.handler.handleRequest(msgContext);
            RequestHeaderClientHandlerTestCase.fail((String)"group id hasn't been set so shouldn't be able to complete request");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        RequestHeaderClientHandler.setCurrentGroupId((String)groupId);
        this.handler.handleRequest(msgContext);
        MimeHeaders headers = message.getMimeHeaders();
        String[] cookie = headers.getHeader("Cookie");
        RequestHeaderClientHandlerTestCase.assertEquals((int)1, (int)cookie.length);
        RequestHeaderClientHandlerTestCase.assertEquals((String)"name=value", (String)cookie[0]);
    }

    public void testBothCookiesHandleRequest() {
        MockSOAPMessage message = new MockSOAPMessage();
        SOAPMessageContext msgContext = MockSOAPMessageContext.createMessageContext((MockSOAPMessage)message, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        ProducerSessionInformation info = new ProducerSessionInformation();
        info.setPerGroupCookies(true);
        String groupId = "group";
        info.setGroupCookieFor(groupId, new Cookie[]{this.createCookie("name", "value", 1)});
        info.setUserCookie(new Cookie[]{this.createCookie("usercookie", "uservalue", 1)});
        RequestHeaderClientHandler.setCurrentInfo((String)groupId, (ProducerSessionInformation)info);
        this.handler.handleRequest(msgContext);
        MimeHeaders headers = message.getMimeHeaders();
        String[] cookie = headers.getHeader("Cookie");
        RequestHeaderClientHandlerTestCase.assertEquals((int)1, (int)cookie.length);
        RequestHeaderClientHandlerTestCase.assertEquals((String)"name=value,usercookie=uservalue", (String)cookie[0]);
    }

    public void testCookieWithoutInitHandleResponse() {
        MockSOAPMessage message = new MockSOAPMessage();
        SOAPMessageContext msgContext = MockSOAPMessageContext.createMessageContext((MockSOAPMessage)message, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        MimeHeaders headers = new MimeHeaders();
        headers.setHeader("Set-Cookie", "name=value");
        message.setMimeHeaders(headers);
        this.handler.handleResponse((MessageContext)msgContext);
        ProducerSessionInformation info = RequestHeaderClientHandler.getCurrentProducerSessionInformation();
        RequestHeaderClientHandlerTestCase.assertEquals((String)"name=value", (String)info.getUserCookie());
        RequestHeaderClientHandlerTestCase.assertFalse((boolean)info.isInitCookieDone());
        RequestHeaderClientHandlerTestCase.assertFalse((boolean)info.isPerGroupCookies());
    }

    public void testMultipleCookiesInResponse() {
        MockSOAPMessage message = new MockSOAPMessage();
        SOAPMessageContext msgContext = MockSOAPMessageContext.createMessageContext((MockSOAPMessage)message, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        MimeHeaders headers = new MimeHeaders();
        headers.addHeader("Set-Cookie", "name1=value1");
        headers.addHeader("Set-Cookie", "name2=value2");
        headers.addHeader("Set-Cookie", "name3=value3");
        message.setMimeHeaders(headers);
        this.handler.handleResponse((MessageContext)msgContext);
        ProducerSessionInformation info = RequestHeaderClientHandler.getCurrentProducerSessionInformation();
        RequestHeaderClientHandlerTestCase.assertEquals((String)"name1=value1,name2=value2,name3=value3", (String)info.getUserCookie());
    }

    public void testCurrentInfo() {
        RequestHeaderClientHandlerTestCase.assertNull((Object)RequestHeaderClientHandler.getCurrentProducerSessionInformation());
        RequestHeaderClientHandlerTestCase.assertNull((Object)RequestHeaderClientHandler.getCurrentGroupId());
        try {
            RequestHeaderClientHandler.setCurrentGroupId((String)"foo");
            RequestHeaderClientHandlerTestCase.fail((String)"Current info was not set, shouldn't have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        ProducerSessionInformation info = new ProducerSessionInformation();
        String groupId = "group";
        RequestHeaderClientHandler.setCurrentInfo((String)groupId, (ProducerSessionInformation)info);
        RequestHeaderClientHandlerTestCase.assertSame((Object)info, (Object)RequestHeaderClientHandler.getCurrentProducerSessionInformation());
        RequestHeaderClientHandlerTestCase.assertEquals((String)groupId, (String)RequestHeaderClientHandler.getCurrentGroupId());
    }

    private Cookie createCookie(String name, String value, int secondsBeforeExpiration) {
        return new Cookie("domain", name, value, "path", secondsBeforeExpiration, false);
    }
}

