/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.protocol.v1;

import java.util.Set;
import junit.framework.TestCase;
import org.gatein.wsrp.consumer.EndpointConfigurationInfo;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.consumer.WSRPConsumerImpl;
import org.gatein.wsrp.consumer.spi.ConsumerRegistrySPI;
import org.gatein.wsrp.services.ServiceFactory;
import org.gatein.wsrp.test.ExtendedAssert;
import org.gatein.wsrp.test.protocol.v1.BehaviorBackedServiceFactory;
import org.gatein.wsrp.test.protocol.v1.BehaviorRegistry;
import org.gatein.wsrp.test.protocol.v1.PortletManagementBehavior;
import org.gatein.wsrp.test.protocol.v1.RegistrationBehavior;
import org.gatein.wsrp.test.protocol.v1.ServiceDescriptionBehavior;
import org.gatein.wsrp.test.protocol.v1.TestProducerBehavior;
import org.gatein.wsrp.test.protocol.v1.TestWSRPProducer;
import org.gatein.wsrp.test.protocol.v1.TestWSRPProducerImpl;
import org.gatein.wsrp.test.protocol.v1.behaviors.BasicMarkupBehavior;
import org.gatein.wsrp.test.protocol.v1.behaviors.BasicPortletManagementBehavior;
import org.gatein.wsrp.test.protocol.v1.behaviors.BasicServiceDescriptionBehavior;
import org.gatein.wsrp.test.protocol.v1.behaviors.EmptyMarkupBehavior;
import org.gatein.wsrp.test.protocol.v1.behaviors.InitCookieNotRequiredMarkupBehavior;
import org.gatein.wsrp.test.protocol.v1.behaviors.NullMarkupBehavior;
import org.gatein.wsrp.test.protocol.v1.behaviors.PerGroupInitCookieMarkupBehavior;
import org.gatein.wsrp.test.protocol.v1.behaviors.PerUserInitCookieMarkupBehavior;
import org.gatein.wsrp.test.protocol.v1.behaviors.ResourceMarkupBehavior;
import org.gatein.wsrp.test.protocol.v1.behaviors.SessionMarkupBehavior;
import org.gatein.wsrp.test.support.MockConsumerRegistry;
import org.gatein.wsrp.test.support.RequestedMarkupBehavior;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WSRP1ConsumerBaseTest
extends TestCase {
    private static Logger log = LoggerFactory.getLogger(WSRP1ConsumerBaseTest.class);
    private static final String TEST_PRODUCER_ID = "test_producer";
    protected TestWSRPProducer producer = new TestWSRPProducerImpl();
    protected WSRPConsumerImpl consumer = new WSRPConsumerImpl(new ProducerInfo((ConsumerRegistrySPI)new MockConsumerRegistry()));
    private boolean strict = true;

    public void setUp() throws Exception {
        this.producer.reset();
        ProducerInfo producerInfo = this.consumer.getProducerInfo();
        producerInfo.setId(TEST_PRODUCER_ID);
        BehaviorRegistry registry = this.producer.getBehaviorRegistry();
        this.setServiceDescriptionBehavior(null);
        this.setPortletManagementBehavior(null);
        this.setRegistrationBehavior(null);
        this.registerAdditionalMarkupBehaviors(registry);
        producerInfo.setEndpointConfigurationInfo(new EndpointConfigurationInfo((ServiceFactory)new BehaviorBackedServiceFactory(registry)));
        producerInfo.setExpirationCacheSeconds(null);
        this.consumer.refreshProducerInfo();
        producerInfo.setExpirationCacheSeconds(Integer.valueOf(120));
    }

    protected void setRegistrationBehavior(RegistrationBehavior behavior) {
        this.producer.getBehaviorRegistry().setRegistrationBehavior(behavior);
    }

    protected void setServiceDescriptionBehavior(ServiceDescriptionBehavior behavior) {
        if (behavior == null) {
            log.debug("Given service description behavior was null, using the default one instead!");
            behavior = new BasicServiceDescriptionBehavior();
        }
        this.producer.getBehaviorRegistry().setServiceDescriptionBehavior(behavior);
    }

    protected void setPortletManagementBehavior(PortletManagementBehavior behavior) {
        BehaviorRegistry registry = this.producer.getBehaviorRegistry();
        if (behavior == null) {
            log.debug("Given portlet management behavior was null, using the default one instead!");
            behavior = new BasicPortletManagementBehavior(registry);
        }
        registry.setPortletManagementBehavior(behavior);
    }

    public void testProducerId() {
        ExtendedAssert.assertEquals((String)TEST_PRODUCER_ID, (String)this.consumer.getProducerId());
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
        this.producer.usingStrictModeChangedTo(strict);
    }

    public boolean isStrict() {
        return this.strict;
    }

    private <T extends TestProducerBehavior> T createBehavior(String behaviorClassName, Class<T> expectedBehaviorClass) {
        if (behaviorClassName != null) {
            try {
                Class<?> behaviorClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(behaviorClassName);
                if (expectedBehaviorClass.isAssignableFrom(behaviorClass)) {
                    return (T)((TestProducerBehavior)expectedBehaviorClass.cast(behaviorClass.newInstance()));
                }
                throw new IllegalArgumentException(behaviorClassName + " is not a " + expectedBehaviorClass.getSimpleName());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Could not find behavior: " + behaviorClassName, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Could not access behavior: " + behaviorClassName, e);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Could not instantiate behavior: " + behaviorClassName, e);
            }
        }
        return null;
    }

    protected void registerAdditionalMarkupBehaviors(BehaviorRegistry registry) {
        registry.registerMarkupBehavior(new BasicMarkupBehavior(registry));
        registry.registerMarkupBehavior(new EmptyMarkupBehavior(registry));
        registry.registerMarkupBehavior(new InitCookieNotRequiredMarkupBehavior(registry));
        registry.registerMarkupBehavior(new PerGroupInitCookieMarkupBehavior(registry));
        registry.registerMarkupBehavior(new PerUserInitCookieMarkupBehavior(registry));
        registry.registerMarkupBehavior(new NullMarkupBehavior(registry));
        registry.registerMarkupBehavior(new SessionMarkupBehavior(registry));
        registry.registerMarkupBehavior(new ResourceMarkupBehavior(registry));
    }

    protected Set<String> getPortletHandles() {
        return this.producer.getBehaviorRegistry().getServiceDescriptionBehavior().getPortletHandles();
    }

    protected int getPortletNumber() {
        return this.producer.getBehaviorRegistry().getServiceDescriptionBehavior().getPortletNumber();
    }

    protected void tearDown() throws Exception {
        RequestedMarkupBehavior.setRequestedMarkupBehavior(null);
    }
}

