/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.protocol.v2;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpSession;
import javax.xml.ws.Holder;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.OpaqueStateString;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.RenderInvocation;
import org.gatein.pc.api.invocation.response.ErrorResponse;
import org.gatein.pc.api.invocation.response.FragmentResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.UpdateNavigationalStateResponse;
import org.gatein.pc.api.spi.InstanceContext;
import org.gatein.pc.api.spi.PortalContext;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.api.spi.SecurityContext;
import org.gatein.pc.api.spi.UserContext;
import org.gatein.pc.api.spi.WindowContext;
import org.gatein.pc.portlet.impl.spi.AbstractInstanceContext;
import org.gatein.pc.portlet.impl.spi.AbstractPortalContext;
import org.gatein.pc.portlet.impl.spi.AbstractSecurityContext;
import org.gatein.pc.portlet.impl.spi.AbstractUserContext;
import org.gatein.pc.portlet.impl.spi.AbstractWindowContext;
import org.gatein.wsrp.WSRPResourceURL;
import org.gatein.wsrp.consumer.handlers.ProducerSessionInformation;
import org.gatein.wsrp.protocol.v2.V2ConsumerBaseTest;
import org.gatein.wsrp.test.ExtendedAssert;
import org.gatein.wsrp.test.protocol.v2.BehaviorRegistry;
import org.gatein.wsrp.test.protocol.v2.behaviors.GroupedPortletsServiceDescriptionBehavior;
import org.gatein.wsrp.test.protocol.v2.behaviors.InitCookieMarkupBehavior;
import org.gatein.wsrp.test.support.MockHttpServletRequest;
import org.gatein.wsrp.test.support.RequestedMarkupBehavior;
import org.gatein.wsrp.test.support.TestPortletInvocationContext;
import org.oasis.wsrp.v2.CookieProtocol;
import org.oasis.wsrp.v2.EventDescription;
import org.oasis.wsrp.v2.ExportDescription;
import org.oasis.wsrp.v2.Extension;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.ItemDescription;
import org.oasis.wsrp.v2.ModelDescription;
import org.oasis.wsrp.v2.ModelTypes;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.PortletDescription;
import org.oasis.wsrp.v2.ResourceList;
import org.oasis.wsrp.v2.ResourceSuspended;

public class MarkupTestCase
extends V2ConsumerBaseTest {
    public void testInvalidHandle() {
        try {
            this.consumer.invoke((PortletInvocation)this.createRenderInvocation("Invalid portlet handle"));
            ExtendedAssert.fail((String)"Should have failed on invalid portlet handle");
        }
        catch (PortletInvokerException portletInvokerException) {
            // empty catch block
        }
    }

    public void testEmptyRender() throws Exception {
        this.checkRenderResult(this.consumer.invoke((PortletInvocation)this.createRenderInvocation("EmptyMarkup")), "");
    }

    public void testNullAction() throws Exception {
        ExtendedAssert.assertTrue((boolean)(this.consumer.invoke((PortletInvocation)this.createActionInvocation("NullMarkup")) instanceof ErrorResponse));
    }

    public void testNullRender() throws Exception {
        ExtendedAssert.assertTrue((boolean)(this.consumer.invoke((PortletInvocation)this.createRenderInvocation("NullMarkup")) instanceof ErrorResponse));
    }

    public void testRender() throws Exception {
        RenderInvocation render = this.createRenderInvocation("SamplePortletHandle", Mode.EDIT, WindowState.NORMAL, "someNS");
        FragmentResponse result = this.checkRenderResult(this.consumer.invoke((PortletInvocation)render), "portlet1:edit:normal:someNS");
        ExtendedAssert.assertEquals((int)15, (int)result.getCacheControl().getExpirationSecs());
        render = this.createRenderInvocation("SecondPortletHandle");
        result = this.checkRenderResult(this.consumer.invoke((PortletInvocation)render), "portlet2:0:view:maximized");
        ExtendedAssert.assertEquals((int)0, (int)result.getCacheControl().getExpirationSecs());
    }

    public void testAction() throws Exception {
        ActionInvocation action = this.createActionInvocation("SamplePortletHandle");
        PortletInvocationResponse response = this.consumer.invoke((PortletInvocation)action);
        ExtendedAssert.assertNotNull((Object)response);
        ExtendedAssert.assertTrue((String)("Was expecting a RenderResponse. Got: " + response), (boolean)(response instanceof UpdateNavigationalStateResponse));
        UpdateNavigationalStateResponse render = (UpdateNavigationalStateResponse)response;
        ExtendedAssert.assertEquals((String)"ns1", (String)render.getNavigationalState().getStringValue());
    }

    public void testSessionHandling() throws Exception {
        RenderInvocation render = this.createRenderInvocation("SecondPortletHandle");
        PortletInvocationResponse response = this.consumer.invoke((PortletInvocation)render);
        this.checkRenderResult(response, "portlet2:0:view:maximized");
        ProducerSessionInformation sessionInfo = this.consumer.getProducerSessionInformationFrom((PortletInvocation)render);
        String sessionId = sessionInfo.getSessionIdForPortlet("SecondPortletHandle");
        ExtendedAssert.assertNotNull((Object)sessionId);
        ExtendedAssert.assertEquals((String)"sessionID", (String)sessionId);
        ExtendedAssert.assertFalse((boolean)sessionInfo.isPerGroupCookies());
        ExtendedAssert.assertFalse((boolean)sessionInfo.isInitCookieDone());
        response = this.consumer.invoke((PortletInvocation)render);
        this.checkRenderResult(response, "portlet2:1:view:maximized");
    }

    public void testInitCookieNotCalledWhenNotNeeded() throws Exception {
        String handle = "InitCookieNotRequired";
        InitCookieMarkupBehavior behavior = (InitCookieMarkupBehavior)this.producer.getBehaviorRegistry().getMarkupBehaviorFor(handle);
        this.consumer.getProducerInfo().setExpirationCacheSeconds(Integer.valueOf(0));
        ExtendedAssert.assertTrue((boolean)this.consumer.getProducerInfo().isRefreshNeeded(true));
        ProducerSessionInformation sessionInfo = this.commonInitCookieTest(handle, behavior, CookieProtocol.NONE.value());
        ExtendedAssert.assertNotNull((Object)sessionInfo);
        ExtendedAssert.assertFalse((boolean)sessionInfo.isPerGroupCookies());
        ExtendedAssert.assertFalse((boolean)sessionInfo.isInitCookieDone());
        ExtendedAssert.assertEquals((int)0, (int)behavior.getInitCookieCallCount());
    }

    public void testInitCookiePerUser() throws PortletInvokerException, InvalidHandle {
        String handle = "PerUserInitCookie";
        InitCookieMarkupBehavior behavior = (InitCookieMarkupBehavior)this.producer.getBehaviorRegistry().getMarkupBehaviorFor(handle);
        ProducerSessionInformation sessionInfo = this.commonInitCookieTest(handle, behavior, CookieProtocol.PER_USER.value());
        ExtendedAssert.assertFalse((boolean)sessionInfo.isPerGroupCookies());
        ExtendedAssert.assertTrue((boolean)sessionInfo.isInitCookieDone());
        ExtendedAssert.assertNotNull((Object)sessionInfo.getUserCookie());
        ExtendedAssert.assertEquals((int)1, (int)behavior.getInitCookieCallCount());
    }

    public void testInitCookiePerGroup() throws PortletInvokerException, OperationFailed, ResourceSuspended, ModifyRegistrationRequired, InvalidRegistration, InvalidHandle {
        BehaviorRegistry registry = this.producer.getBehaviorRegistry();
        Holder offeredPortlets = new Holder();
        registry.getServiceDescriptionBehavior().getServiceDescription(null, null, null, null, (Holder<Boolean>)new Holder(), (Holder<List<PortletDescription>>)offeredPortlets, (Holder<List<ItemDescription>>)new Holder(), null, (Holder<List<ItemDescription>>)new Holder(), (Holder<List<ItemDescription>>)new Holder(), (Holder<CookieProtocol>)new Holder(), (Holder<ModelDescription>)new Holder(), (Holder<List<String>>)new Holder(), (Holder<ResourceList>)new Holder(), (Holder<List<EventDescription>>)new Holder(), (Holder<ModelTypes>)new Holder(), (Holder<List<String>>)new Holder(), (Holder<ExportDescription>)new Holder(), (Holder<Boolean>)new Holder(), (Holder<List<Extension>>)new Holder());
        this.setServiceDescriptionBehavior(new GroupedPortletsServiceDescriptionBehavior((List)offeredPortlets.value));
        String handle = "PerGroupInitCookie";
        InitCookieMarkupBehavior behavior = (InitCookieMarkupBehavior)registry.getMarkupBehaviorFor(handle);
        ProducerSessionInformation sessionInfo = this.commonInitCookieTest(handle, behavior, CookieProtocol.PER_GROUP.value());
        ExtendedAssert.assertTrue((boolean)sessionInfo.isPerGroupCookies());
        ExtendedAssert.assertTrue((boolean)sessionInfo.isInitCookieDone());
        ExtendedAssert.assertNull((Object)sessionInfo.getUserCookie());
        ExtendedAssert.assertEquals((int)3, (int)behavior.getInitCookieCallCount());
    }

    public void testResource() throws PortletInvokerException, MalformedURLException {
        RenderInvocation render = this.createRenderInvocation("resource");
        PortletInvocationResponse response = this.consumer.invoke((PortletInvocation)render);
        String resourceID = WSRPResourceURL.encodeResource(null, (URL)new URL("http://localhost:8080/test-resource-portlet/gif/logo.gif"), (boolean)false);
        String expectedResult = "<img src='http://test/mock:type=resource?mock:ComponentID=foobar&amp;mock:resourceID=" + resourceID + "'/>";
        this.checkRenderResult(response, expectedResult);
    }

    private ProducerSessionInformation commonInitCookieTest(String handle, InitCookieMarkupBehavior behavior, String cookieProtocol) throws PortletInvokerException {
        RenderInvocation render = this.createRenderInvocation(handle);
        TestPortletInvocationContext invocationContext = (TestPortletInvocationContext)render.getContext();
        HttpSession session = invocationContext.getClientRequest().getSession();
        this.producer.setRequiresInitCookie(CookieProtocol.fromValue((String)cookieProtocol));
        this.consumer.refreshProducerInfo();
        this.producer.setCurrentMarkupBehaviorHandle(handle);
        render = this.createRenderInvocation(handle, invocationContext);
        ExtendedAssert.assertEquals((int)0, (int)behavior.getInitCookieCallCount());
        this.consumer.invoke((PortletInvocation)render);
        ExtendedAssert.assertEquals((String)cookieProtocol, (String)this.consumer.getProducerInfo().getRequiresInitCookie().value());
        return this.consumer.getProducerSessionInformationFrom(session);
    }

    private FragmentResponse checkRenderResult(PortletInvocationResponse response, String markup) {
        ExtendedAssert.assertNotNull((Object)response);
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)response;
            ExtendedAssert.fail((String)("Got an ErrorResponse instead of a FragmentResponse. Message: " + errorResponse.getMessage()));
        }
        ExtendedAssert.assertTrue((String)("Was expecting a FragmentResponse. Got: " + response), (boolean)(response instanceof FragmentResponse));
        FragmentResponse fragment = (FragmentResponse)response;
        ExtendedAssert.assertEquals((String)markup, (String)fragment.getChars().toString());
        return fragment;
    }

    private RenderInvocation createRenderInvocation(String portletHandle) {
        return this.createRenderInvocation(portletHandle, null);
    }

    private RenderInvocation createRenderInvocation(String portletHandle, TestPortletInvocationContext invocationContext) {
        return this.createRenderInvocation(portletHandle, Mode.VIEW, WindowState.MAXIMIZED, null, invocationContext);
    }

    private RenderInvocation createRenderInvocation(String portletHandle, Mode mode, WindowState state, String navigationalState) {
        return this.createRenderInvocation(portletHandle, mode, state, navigationalState, null);
    }

    private RenderInvocation createRenderInvocation(String portletHandle, Mode mode, WindowState state, String navigationalState, TestPortletInvocationContext invocationContext) {
        if (invocationContext == null) {
            invocationContext = new TestPortletInvocationContext();
        }
        RenderInvocation render = new RenderInvocation((PortletInvocationContext)invocationContext);
        render.setTarget(PortletContext.createPortletContext((String)portletHandle, (boolean)false));
        render.setMode(mode);
        render.setWindowState(state);
        if (navigationalState != null) {
            render.setNavigationalState((StateString)new OpaqueStateString(navigationalState));
        }
        render.setInstanceContext((InstanceContext)new AbstractInstanceContext(portletHandle));
        render.setSecurityContext((SecurityContext)new AbstractSecurityContext(MockHttpServletRequest.createMockRequest(null)));
        render.setUserContext((UserContext)new MockUserContext());
        render.setWindowContext((WindowContext)new AbstractWindowContext("windowcontext"));
        render.setPortalContext((PortalContext)new AbstractPortalContext());
        RequestedMarkupBehavior.setRequestedMarkupBehavior(portletHandle);
        return render;
    }

    private ActionInvocation createActionInvocation(String portletHandle) {
        TestPortletInvocationContext ac = new TestPortletInvocationContext();
        ActionInvocation action = new ActionInvocation((PortletInvocationContext)ac);
        action.setInstanceContext((InstanceContext)new AbstractInstanceContext(portletHandle));
        action.setSecurityContext((SecurityContext)new AbstractSecurityContext(MockHttpServletRequest.createMockRequest(null)));
        action.setUserContext((UserContext)new MockUserContext());
        action.setTarget(PortletContext.createPortletContext((String)portletHandle, (boolean)false));
        RequestedMarkupBehavior.setRequestedMarkupBehavior(portletHandle);
        return action;
    }

    static class MockUserContext
    extends AbstractUserContext {
        MockUserContext() {
        }

        public List<Locale> getLocales() {
            return Collections.singletonList(Locale.ENGLISH);
        }
    }
}

