/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.test.protocol.v1;

import org.gatein.common.NotYetImplemented;
import org.gatein.common.util.Version;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.WindowState;
import org.gatein.wsrp.services.MarkupService;
import org.gatein.wsrp.services.PortletManagementService;
import org.gatein.wsrp.services.RegistrationService;
import org.gatein.wsrp.services.ServiceDescriptionService;
import org.gatein.wsrp.services.ServiceFactory;
import org.gatein.wsrp.services.v1.V1MarkupService;
import org.gatein.wsrp.services.v1.V1PortletManagementService;
import org.gatein.wsrp.services.v1.V1RegistrationService;
import org.gatein.wsrp.services.v1.V1ServiceDescriptionService;
import org.gatein.wsrp.test.protocol.v1.BehaviorRegistry;
import org.gatein.wsrp.test.protocol.v1.MarkupBehavior;
import org.gatein.wsrp.test.support.RequestedMarkupBehavior;
import org.oasis.wsrp.v1.V1AccessDenied;
import org.oasis.wsrp.v1.V1GetMarkup;
import org.oasis.wsrp.v1.V1InconsistentParameters;
import org.oasis.wsrp.v1.V1InvalidCookie;
import org.oasis.wsrp.v1.V1InvalidHandle;
import org.oasis.wsrp.v1.V1InvalidRegistration;
import org.oasis.wsrp.v1.V1InvalidSession;
import org.oasis.wsrp.v1.V1InvalidUserCategory;
import org.oasis.wsrp.v1.V1MissingParameters;
import org.oasis.wsrp.v1.V1OperationFailed;
import org.oasis.wsrp.v1.V1UnsupportedLocale;
import org.oasis.wsrp.v1.V1UnsupportedMimeType;
import org.oasis.wsrp.v1.V1UnsupportedMode;
import org.oasis.wsrp.v1.V1UnsupportedWindowState;
import org.oasis.wsrp.v1.WSRPV1MarkupPortType;
import org.oasis.wsrp.v1.WSRPV1PortletManagementPortType;
import org.oasis.wsrp.v1.WSRPV1RegistrationPortType;
import org.oasis.wsrp.v1.WSRPV1ServiceDescriptionPortType;

public class BehaviorBackedServiceFactory
implements ServiceFactory {
    private BehaviorRegistry registry;
    private static final String MARKUP = "markup";
    private boolean initialized = false;
    private String wsdl = "http://example.com/producer?wsdl";
    public static final String DEFAULT_WSDL_URL = "http://example.com/producer?wsdl";
    private int timeout;

    public BehaviorBackedServiceFactory() {
        this(new BehaviorRegistry());
    }

    public BehaviorBackedServiceFactory(BehaviorRegistry registry) {
        this.registry = registry;
        registry.registerMarkupBehavior(new SimpleMarkupBehavior());
    }

    public <T> T getService(Class<T> serviceClass) throws Exception {
        if (!this.isAvailable() && !this.isFailed()) {
            this.start();
        }
        if (WSRPV1ServiceDescriptionPortType.class.isAssignableFrom(serviceClass)) {
            return (T)this.registry.getServiceDescriptionBehavior();
        }
        if (WSRPV1MarkupPortType.class.isAssignableFrom(serviceClass)) {
            String requestedMarkupBehavior = RequestedMarkupBehavior.getRequestedMarkupBehavior();
            if (requestedMarkupBehavior == null) {
                requestedMarkupBehavior = MARKUP;
            }
            return (T)this.registry.getMarkupBehaviorFor(requestedMarkupBehavior);
        }
        if (WSRPV1PortletManagementPortType.class.isAssignableFrom(serviceClass)) {
            return (T)this.registry.getPortletManagementBehavior();
        }
        if (WSRPV1RegistrationPortType.class.isAssignableFrom(serviceClass)) {
            return (T)this.registry.getRegistrationBehavior();
        }
        return null;
    }

    public BehaviorRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(BehaviorRegistry registry) {
        this.registry = registry;
    }

    public boolean isAvailable() {
        return this.initialized;
    }

    public boolean isFailed() {
        return false;
    }

    public void setFailed(boolean failed) {
    }

    public void setWSOperationTimeOut(int msBeforeTimeOut) {
        if (msBeforeTimeOut < 0) {
            msBeforeTimeOut = 10000;
        }
        this.timeout = msBeforeTimeOut;
    }

    public int getWSOperationTimeOut() {
        return this.timeout;
    }

    public ServiceDescriptionService getServiceDescriptionService() throws Exception {
        return new V1ServiceDescriptionService(this.getService(WSRPV1ServiceDescriptionPortType.class));
    }

    public MarkupService getMarkupService() throws Exception {
        return new V1MarkupService(this.getService(WSRPV1MarkupPortType.class));
    }

    public PortletManagementService getPortletManagementService() throws Exception {
        return new V1PortletManagementService(this.getService(WSRPV1PortletManagementPortType.class));
    }

    public RegistrationService getRegistrationService() throws Exception {
        return new V1RegistrationService(this.getService(WSRPV1RegistrationPortType.class));
    }

    public Version getWSRPVersion() {
        return ServiceFactory.WSRP1;
    }

    public boolean refresh(boolean force) throws Exception {
        if (force || !this.isAvailable() && !this.isFailed()) {
            this.start();
            return true;
        }
        return false;
    }

    public void create() throws Exception {
        throw new NotYetImplemented();
    }

    public void start() throws Exception {
        this.initialized = true;
    }

    public void stop() {
        throw new NotYetImplemented();
    }

    public void setWsdlDefinitionURL(String wsdlDefinitionURL) {
        this.wsdl = wsdlDefinitionURL;
    }

    public String getWsdlDefinitionURL() {
        return this.wsdl;
    }

    public void destroy() {
        throw new NotYetImplemented();
    }

    public void enableWSS(boolean enable) {
    }

    public boolean isWSSEnabled() {
        return false;
    }

    public boolean isWSSAvailable() {
        return false;
    }

    private class SimpleMarkupBehavior
    extends MarkupBehavior {
        public SimpleMarkupBehavior() {
            super(BehaviorBackedServiceFactory.this.registry);
            this.registerHandle(BehaviorBackedServiceFactory.MARKUP);
        }

        @Override
        protected String getMarkupString(Mode mode, WindowState windowState, String navigationalState, V1GetMarkup getMarkup) throws V1UnsupportedWindowState, V1InvalidCookie, V1InvalidSession, V1AccessDenied, V1InconsistentParameters, V1InvalidHandle, V1UnsupportedLocale, V1UnsupportedMode, V1OperationFailed, V1MissingParameters, V1InvalidUserCategory, V1InvalidRegistration, V1UnsupportedMimeType {
            return BehaviorBackedServiceFactory.MARKUP;
        }
    }
}

