/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.test.protocol.v1;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jws.WebParam;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.spec.v1.WSRP1TypeFactory;
import org.gatein.wsrp.test.protocol.v1.TestProducerBehavior;
import org.oasis.wsrp.v1.V1CookieProtocol;
import org.oasis.wsrp.v1.V1Extension;
import org.oasis.wsrp.v1.V1InvalidRegistration;
import org.oasis.wsrp.v1.V1ItemDescription;
import org.oasis.wsrp.v1.V1ModelDescription;
import org.oasis.wsrp.v1.V1OperationFailed;
import org.oasis.wsrp.v1.V1PortletDescription;
import org.oasis.wsrp.v1.V1PropertyDescription;
import org.oasis.wsrp.v1.V1RegistrationContext;
import org.oasis.wsrp.v1.V1ResourceList;
import org.oasis.wsrp.v1.V1ServiceDescription;
import org.oasis.wsrp.v1.WSRPV1ServiceDescriptionPortType;

public class ServiceDescriptionBehavior
extends TestProducerBehavior
implements WSRPV1ServiceDescriptionPortType {
    protected V1ServiceDescription serviceDescription;
    private static final V1ServiceDescription DEFAULT_SERVICE_DESCRIPTION = WSRP1TypeFactory.createServiceDescription((boolean)false);
    public static final ServiceDescriptionBehavior DEFAULT = new ServiceDescriptionBehavior();
    protected List<V1PortletDescription> offeredPortlets = new LinkedList<V1PortletDescription>();
    private boolean requiresRegistration;
    private V1CookieProtocol cookieProtocol;
    private V1ModelDescription registrationProperties;

    public void setRequiresRegistration(boolean requiresRegistration) {
        this.requiresRegistration = requiresRegistration;
    }

    public void setRequiresInitCookie(V1CookieProtocol requiresInitCookie) {
        this.cookieProtocol = requiresInitCookie;
    }

    public void setServiceDescription(boolean requiresRegistration, int numberOfProps) {
        V1ServiceDescription sd = ServiceDescriptionBehavior.createServiceDescription(requiresRegistration, numberOfProps);
        this.offeredPortlets = sd.getOfferedPortlets();
        this.requiresRegistration = sd.isRequiresRegistration();
        this.registrationProperties = sd.getRegistrationPropertyDescription();
    }

    public static V1ServiceDescription getDefaultServiceDescription() {
        return DEFAULT_SERVICE_DESCRIPTION;
    }

    public void addPortletDescription(V1PortletDescription portletDescription) {
        this.offeredPortlets.add(portletDescription);
    }

    public Set<String> getPortletHandles() {
        HashSet<String> handles = new HashSet<String>(this.offeredPortlets.size());
        for (V1PortletDescription description : this.offeredPortlets) {
            handles.add(description.getPortletHandle());
        }
        return handles;
    }

    public int getPortletNumber() {
        return this.offeredPortlets.size();
    }

    public static V1ServiceDescription createServiceDescription(boolean requiresRegistration, int numberOfProperties) {
        V1ServiceDescription sd = WSRP1TypeFactory.createServiceDescription((boolean)requiresRegistration);
        if (requiresRegistration) {
            ArrayList<V1PropertyDescription> descriptions = new ArrayList<V1PropertyDescription>(numberOfProperties);
            for (int i = 0; i < numberOfProperties; ++i) {
                descriptions.add(WSRP1TypeFactory.createPropertyDescription((String)("prop" + i), (QName)WSRPConstants.XSD_STRING));
            }
            sd.setRegistrationPropertyDescription(WSRP1TypeFactory.createModelDescription(descriptions));
        }
        return sd;
    }

    public void getServiceDescription(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="desiredLocales", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") List<String> desiredLocales, @WebParam(mode=WebParam.Mode.OUT, name="requiresRegistration", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<Boolean> requiresRegistration, @WebParam(mode=WebParam.Mode.OUT, name="offeredPortlets", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1PortletDescription>> offeredPortlets, @WebParam(mode=WebParam.Mode.OUT, name="userCategoryDescriptions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1ItemDescription>> userCategoryDescriptions, @WebParam(mode=WebParam.Mode.OUT, name="customUserProfileItemDescriptions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1ItemDescription>> customUserProfileItemDescriptions, @WebParam(mode=WebParam.Mode.OUT, name="customWindowStateDescriptions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1ItemDescription>> customWindowStateDescriptions, @WebParam(mode=WebParam.Mode.OUT, name="customModeDescriptions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1ItemDescription>> customModeDescriptions, @WebParam(mode=WebParam.Mode.OUT, name="requiresInitCookie", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<V1CookieProtocol> requiresInitCookie, @WebParam(mode=WebParam.Mode.OUT, name="registrationPropertyDescription", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<V1ModelDescription> registrationPropertyDescription, @WebParam(mode=WebParam.Mode.OUT, name="locales", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<String>> locales, @WebParam(mode=WebParam.Mode.OUT, name="resourceList", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<V1ResourceList> resourceList, @WebParam(mode=WebParam.Mode.OUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions) throws V1InvalidRegistration, V1OperationFailed {
        this.incrementCallCount();
        offeredPortlets.value = this.offeredPortlets;
        requiresRegistration.value = this.requiresRegistration;
        requiresInitCookie.value = this.cookieProtocol;
        registrationPropertyDescription.value = this.registrationProperties;
    }
}

