/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.test.protocol.v1.behaviors;

import java.util.List;
import javax.jws.WebParam;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.WindowState;
import org.gatein.wsrp.spec.v1.WSRP1ExceptionFactory;
import org.gatein.wsrp.test.protocol.v1.BehaviorRegistry;
import org.gatein.wsrp.test.protocol.v1.MarkupBehavior;
import org.oasis.wsrp.v1.V1AccessDenied;
import org.oasis.wsrp.v1.V1Extension;
import org.oasis.wsrp.v1.V1GetMarkup;
import org.oasis.wsrp.v1.V1InvalidCookie;
import org.oasis.wsrp.v1.V1InvalidRegistration;
import org.oasis.wsrp.v1.V1OperationFailed;
import org.oasis.wsrp.v1.V1RegistrationContext;

public abstract class InitCookieMarkupBehavior
extends MarkupBehavior {
    protected String portletHandle;
    protected int initCookieCallCount;
    private boolean initCookieCalled;

    public InitCookieMarkupBehavior(BehaviorRegistry registry) {
        super(registry);
        this.initPortletHandle();
        this.registerHandle(this.portletHandle);
    }

    protected abstract void initPortletHandle();

    @Override
    protected String getMarkupString(Mode mode, WindowState windowState, String navigationalState, V1GetMarkup getMarkup) throws V1OperationFailed, V1InvalidCookie {
        if (!this.initCookieCalled) {
            throw new IllegalStateException("initCookie should have been called first!");
        }
        String handle = getMarkup.getPortletContext().getPortletHandle();
        if (this.portletHandle.equals(handle)) {
            return this.getMarkupString(handle);
        }
        throw (V1OperationFailed)WSRP1ExceptionFactory.throwWSException(V1OperationFailed.class, (String)"Shouldn't happen", null);
    }

    protected String getMarkupString(String handle) throws V1InvalidCookie, V1OperationFailed {
        switch (this.callCount++) {
            case 0: {
                throw (V1InvalidCookie)WSRP1ExceptionFactory.throwWSException(V1InvalidCookie.class, (String)"Simulate invalid cookie", null);
            }
            case 1: {
                return handle;
            }
        }
        throw (V1OperationFailed)WSRP1ExceptionFactory.throwWSException(V1OperationFailed.class, (String)"Shouldn't be called more than twice", null);
    }

    @Override
    public List<V1Extension> initCookie(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext) throws V1InvalidRegistration, V1AccessDenied, V1OperationFailed {
        this.initCookieCalled = true;
        ++this.initCookieCallCount;
        return null;
    }

    public int getInitCookieCallCount() {
        return this.initCookieCallCount;
    }
}

