/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.test.support;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.common.net.media.MediaType;
import org.gatein.common.util.MarkupInfo;
import org.gatein.pc.api.ActionURL;
import org.gatein.pc.api.ContainerURL;
import org.gatein.pc.api.RenderURL;
import org.gatein.pc.api.ResourceURL;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.URLFormat;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.portlet.impl.spi.AbstractPortletInvocationContext;
import org.gatein.wsrp.test.support.MockHttpServletRequest;
import org.gatein.wsrp.test.support.MockHttpServletResponse;

public class TestPortletInvocationContext
extends AbstractPortletInvocationContext
implements PortletInvocationContext {
    private HttpServletRequest mockRequest = MockHttpServletRequest.createMockRequest(null);
    private HttpServletResponse mockResponse = MockHttpServletResponse.createMockResponse();

    public TestPortletInvocationContext() {
        super(new MarkupInfo(MediaType.TEXT_HTML, "UTF-8"));
    }

    public void setMockRequest(HttpServletRequest mockRequest) {
        this.mockRequest = mockRequest;
    }

    public void setMockResponse(HttpServletResponse mockResponse) {
        this.mockResponse = mockResponse;
    }

    public HttpServletRequest getClientRequest() {
        if (this.mockRequest == null) {
            throw new IllegalStateException();
        }
        return this.mockRequest;
    }

    public HttpServletResponse getClientResponse() {
        if (this.mockResponse == null) {
            throw new IllegalStateException();
        }
        return this.mockResponse;
    }

    public String encodeResourceURL(String url) {
        return null;
    }

    public String renderURL(ContainerURL containerURL, URLFormat urlFormat) {
        String result;
        if (containerURL instanceof ActionURL) {
            ActionURL actionURL = (ActionURL)containerURL;
            result = "Action is=" + actionURL.getInteractionState().getStringValue();
        } else if (containerURL instanceof RenderURL) {
            result = "Render";
        } else {
            String url = "http://test/mock:type=resource?mock:ComponentID=foobar";
            ResourceURL resourceURL = (ResourceURL)containerURL;
            url = urlFormat.getWantEscapeXML() != false ? url + "&amp;" : url + "&";
            url = url + "mock:resourceID=" + resourceURL.getResourceId();
            return url;
        }
        StateString ns = containerURL.getNavigationalState();
        result = result + " ns=" + (ns != null ? ns.getStringValue() : null) + " ws=" + containerURL.getWindowState() + " m=" + containerURL.getMode();
        return result;
    }
}

