/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.state;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.chromattic.api.ChromatticSession;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.state.PropertyMap;
import org.gatein.pc.portlet.state.InvalidStateIdException;
import org.gatein.pc.portlet.state.NoSuchStateException;
import org.gatein.pc.portlet.state.producer.AbstractPortletStatePersistenceManager;
import org.gatein.pc.portlet.state.producer.PortletStateContext;
import org.gatein.wsrp.jcr.ChromatticPersister;
import org.gatein.wsrp.producer.state.mapping.PortletStateContextMapping;
import org.gatein.wsrp.producer.state.mapping.PortletStateContextsMapping;
import org.gatein.wsrp.producer.state.mapping.PortletStateMapping;

public class JCRPortletStatePersistenceManager
extends AbstractPortletStatePersistenceManager {
    private ChromatticPersister persister;
    private static final String PATH = "pc:producerstates/";
    public static final List<Class> mappingClasses = new ArrayList<Class>(3);

    public JCRPortletStatePersistenceManager(ChromatticPersister persister) throws Exception {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)persister, (String)"ChromatticPersister");
        this.persister = persister;
    }

    private PortletStateContextsMapping getContexts(ChromatticSession session) {
        PortletStateContextsMapping portletStateContexts = (PortletStateContextsMapping)session.findByPath(PortletStateContextsMapping.class, "pc:producerstates");
        if (portletStateContexts == null) {
            portletStateContexts = (PortletStateContextsMapping)session.insert(PortletStateContextsMapping.class, "pc:producerstates");
        }
        return portletStateContexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateState(String stateId, PropertyMap propertyMap) throws NoSuchStateException, InvalidStateIdException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyMap, (String)"property map");
        try {
            ChromatticSession session = this.persister.getSession();
            PortletStateContextMapping pscm = this.getPortletStateContextMapping(session, stateId);
            PortletStateMapping psm = pscm.getState();
            psm.setProperties(propertyMap);
            this.persister.save();
        }
        finally {
            this.persister.closeSession(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PortletStateContext getStateContext(String stateId) {
        try {
            ChromatticSession session = this.persister.getSession();
            PortletStateContextMapping pscm = this.getPortletStateContextMapping(session, stateId);
            PortletStateContext context = pscm == null ? null : pscm.toPortletStateContext();
            PortletStateContext portletStateContext = context;
            return portletStateContext;
        }
        finally {
            this.persister.closeSession(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createStateContext(String portletId, PropertyMap propertyMap) {
        try {
            ChromatticSession session = this.persister.getSession();
            PortletStateContextsMapping portletStateContexts = this.getContexts(session);
            PortletStateContextMapping pscm = portletStateContexts.createPortletStateContext(UUID.randomUUID().toString());
            portletStateContexts.getPortletStateContexts().add(pscm);
            PortletStateMapping psm = pscm.getState();
            psm.setPortletID(portletId);
            psm.setProperties(propertyMap);
            String key = pscm.getPersistentKey();
            this.persister.save();
            String string = key;
            return string;
        }
        finally {
            this.persister.closeSession(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PortletStateContext destroyStateContext(String stateId) {
        try {
            PortletStateContext result;
            ChromatticSession session = this.persister.getSession();
            PortletStateContextMapping pscm = this.getPortletStateContextMapping(session, stateId);
            if (pscm == null) {
                result = null;
            } else {
                this.getContexts(session).getPortletStateContexts().remove(pscm);
                result = pscm.toPortletStateContext();
            }
            this.persister.save();
            PortletStateContext portletStateContext = result;
            return portletStateContext;
        }
        finally {
            this.persister.closeSession(false);
        }
    }

    protected void updateStateContext(PortletStateContext stateContext) {
        throw new UnsupportedOperationException("Shouldn't be called as updateState method is overriden!");
    }

    private PortletStateContextMapping getPortletStateContextMapping(ChromatticSession session, String stateId) {
        return this.getContexts(session).findPortletStateContextById(stateId);
    }

    static {
        Collections.addAll(mappingClasses, PortletStateContextsMapping.class, PortletStateContextMapping.class, PortletStateMapping.class);
    }
}

