/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.handlers.processors;

import java.util.Collection;
import java.util.List;
import org.gatein.common.NotYetImplemented;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.invocation.EventInvocation;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.UpdateNavigationalStateResponse;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.api.state.AccessMode;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.payload.PayloadUtils;
import org.gatein.wsrp.producer.handlers.processors.ProducerHelper;
import org.gatein.wsrp.producer.handlers.processors.UpdateNavigationalStateResponseProcessor;
import org.gatein.wsrp.producer.handlers.processors.WSRPPortletInvocationContext;
import org.gatein.wsrp.spec.v2.WSRP2ExceptionFactory;
import org.oasis.wsrp.v2.Event;
import org.oasis.wsrp.v2.EventParams;
import org.oasis.wsrp.v2.HandleEvents;
import org.oasis.wsrp.v2.HandleEventsResponse;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.MimeRequest;
import org.oasis.wsrp.v2.MissingParameters;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.OperationNotSupported;
import org.oasis.wsrp.v2.PortletContext;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.RuntimeContext;
import org.oasis.wsrp.v2.StateChange;
import org.oasis.wsrp.v2.UnsupportedLocale;
import org.oasis.wsrp.v2.UnsupportedMimeType;
import org.oasis.wsrp.v2.UnsupportedMode;
import org.oasis.wsrp.v2.UnsupportedWindowState;
import org.oasis.wsrp.v2.UpdateResponse;
import org.oasis.wsrp.v2.UserContext;

class EventRequestProcessor
extends UpdateNavigationalStateResponseProcessor<HandleEventsResponse> {
    private HandleEvents handleEvents;

    public EventRequestProcessor(ProducerHelper producer, HandleEvents handleEvents) throws OperationFailed, UnsupportedMode, InvalidHandle, MissingParameters, UnsupportedMimeType, UnsupportedWindowState, InvalidRegistration, OperationNotSupported, ModifyRegistrationRequired, UnsupportedLocale {
        super(producer);
        this.handleEvents = handleEvents;
        EventParams eventParams = handleEvents.getEventParams();
        WSRP2ExceptionFactory.throwMissingParametersIfValueIsMissing((Object)eventParams, (String)"event params", (String)this.getContextName());
        WSRP2ExceptionFactory.throwMissingParametersIfValueIsMissing((Object)eventParams.getPortletStateChange(), (String)"portletStateChange", (String)"EventParams");
        List events = eventParams.getEvents();
        if (!ParameterValidation.existsAndIsNotEmpty((Collection)events)) {
            throw (MissingParameters)WSRP2ExceptionFactory.createWSException(MissingParameters.class, (String)"EventParams must provide at least one event to process", null);
        }
        if (events.size() > 1) {
            throw (OperationNotSupported)WSRP2ExceptionFactory.createWSException(OperationNotSupported.class, (String)"GateIn currently doesn't support sending multiple events to process at once.", null);
        }
        this.prepareInvocation();
    }

    @Override
    RegistrationContext getRegistrationContext() {
        return this.handleEvents.getRegistrationContext();
    }

    @Override
    RuntimeContext getRuntimeContext() {
        return this.handleEvents.getRuntimeContext();
    }

    @Override
    MimeRequest getParams() {
        return this.handleEvents.getMarkupParams();
    }

    @Override
    public PortletContext getPortletContext() {
        return this.handleEvents.getPortletContext();
    }

    @Override
    UserContext getUserContext() {
        return this.handleEvents.getUserContext();
    }

    @Override
    String getContextName() {
        return "HandleEvents";
    }

    @Override
    AccessMode getAccessMode() throws MissingParameters {
        StateChange stateChange = this.handleEvents.getEventParams().getPortletStateChange();
        return WSRPUtils.getAccessModeFromStateChange((StateChange)stateChange);
    }

    @Override
    PortletInvocation initInvocation(WSRPPortletInvocationContext context) {
        EventInvocation eventInvocation = new EventInvocation((PortletInvocationContext)context);
        List events = this.handleEvents.getEventParams().getEvents();
        if (events.size() > 1) {
            throw new NotYetImplemented("Need to support multiple events at once...");
        }
        Event event = (Event)events.get(0);
        eventInvocation.setName(event.getName());
        eventInvocation.setPayload(PayloadUtils.getPayloadAsSerializable((Event)event));
        return eventInvocation;
    }

    @Override
    protected HandleEventsResponse internalProcessResponse(PortletInvocationResponse response) {
        if (response instanceof UpdateNavigationalStateResponse) {
            UpdateNavigationalStateResponse unsResponse = (UpdateNavigationalStateResponse)response;
            HandleEventsResponse eventsResponse = WSRPTypeFactory.createHandleEventsReponse();
            UpdateResponse updateResponse = this.createUpdateResponse(unsResponse);
            eventsResponse.setUpdateResponse(updateResponse);
            return eventsResponse;
        }
        throw new IllegalArgumentException("Cannot process response: " + response);
    }
}

