/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.handlers.processors;

import org.gatein.wsrp.producer.handlers.processors.ActionRequestProcessor;
import org.gatein.wsrp.producer.handlers.processors.EventRequestProcessor;
import org.gatein.wsrp.producer.handlers.processors.ProducerHelper;
import org.gatein.wsrp.producer.handlers.processors.RenderRequestProcessor;
import org.gatein.wsrp.producer.handlers.processors.RequestProcessor;
import org.gatein.wsrp.producer.handlers.processors.ResourceRequestProcessor;
import org.gatein.wsrp.spec.v2.WSRP2ExceptionFactory;
import org.oasis.wsrp.v2.GetMarkup;
import org.oasis.wsrp.v2.GetResource;
import org.oasis.wsrp.v2.HandleEvents;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.MissingParameters;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.OperationNotSupported;
import org.oasis.wsrp.v2.PerformBlockingInteraction;
import org.oasis.wsrp.v2.UnsupportedLocale;
import org.oasis.wsrp.v2.UnsupportedMimeType;
import org.oasis.wsrp.v2.UnsupportedMode;
import org.oasis.wsrp.v2.UnsupportedWindowState;

public class ProcessorFactory {
    public static RequestProcessor getProcessorFor(ProducerHelper producer, Object request) throws OperationFailed, UnsupportedMode, InvalidHandle, MissingParameters, UnsupportedMimeType, UnsupportedWindowState, InvalidRegistration, ModifyRegistrationRequired, UnsupportedLocale {
        if (request instanceof GetMarkup) {
            return new RenderRequestProcessor(producer, (GetMarkup)request);
        }
        if (request instanceof PerformBlockingInteraction) {
            PerformBlockingInteraction performBlockingInteraction = (PerformBlockingInteraction)request;
            return new ActionRequestProcessor(producer, performBlockingInteraction);
        }
        if (request instanceof HandleEvents) {
            HandleEvents handleEvents = (HandleEvents)request;
            try {
                return new EventRequestProcessor(producer, handleEvents);
            }
            catch (OperationNotSupported operationNotSupported) {
                throw (OperationFailed)WSRP2ExceptionFactory.createWSException(OperationFailed.class, (String)"Couldn't initiate EventRequestProcessor", (Throwable)operationNotSupported);
            }
        }
        if (request instanceof GetResource) {
            GetResource getResource = (GetResource)request;
            return new ResourceRequestProcessor(producer, getResource);
        }
        throw new IllegalArgumentException("Unknown request type: " + request.getClass().getSimpleName());
    }
}

