/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import java.util.Arrays;
import java.util.Iterator;
import org.geolatte.geom.Complex;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.GeometryVisitor;
import org.geolatte.geom.Position;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public abstract class AbstractGeometryCollection<P extends Position, G extends Geometry<P>>
extends Geometry<P>
implements Complex<P, G> {
    protected final Geometry<P>[] geometries;

    @SafeVarargs
    public AbstractGeometryCollection(G ... geometries) {
        super(AbstractGeometryCollection.nestPositionSequences(geometries), AbstractGeometryCollection.getCrs(geometries));
        this.check((Geometry[])geometries);
        this.geometries = (Geometry[])Arrays.copyOf(geometries, geometries.length);
    }

    public AbstractGeometryCollection(CoordinateReferenceSystem<P> crs) {
        super(crs);
        this.geometries = new Geometry[0];
    }

    @Override
    public int getNumGeometries() {
        return this.geometries.length;
    }

    @Override
    public Class<? extends Geometry> getComponentType() {
        return Geometry.class;
    }

    @Override
    public G[] components() {
        return Arrays.copyOf(this.geometries, this.geometries.length);
    }

    public G getGeometryN(int num) {
        return (G)this.geometries[num];
    }

    @Override
    public int getDimension() {
        int maxDim = 0;
        for (Geometry part : this) {
            maxDim = Math.max(maxDim, part.getDimension());
        }
        return maxDim;
    }

    @Override
    public GeometryType getGeometryType() {
        return GeometryType.GEOMETRYCOLLECTION;
    }

    @Override
    public Iterator<G> iterator() {
        return new Iterator<G>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < AbstractGeometryCollection.this.geometries.length;
            }

            @Override
            public G next() {
                return AbstractGeometryCollection.this.geometries[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void accept(GeometryVisitor<P> visitor) {
        visitor.visit(this);
        for (Geometry part : this) {
            part.accept(visitor);
        }
        visitor.endVisit(this);
    }

    private void check(G[] geometries) {
        if (geometries == null || geometries.length == 0) {
            return;
        }
        String msg = "NULL element not allowd in Geometry array";
        if (geometries[0] == null) {
            throw new IllegalStateException(msg);
        }
        CoordinateReferenceSystem crs = ((Geometry)geometries[0]).getCoordinateReferenceSystem();
        for (int i = 1; i < geometries.length; ++i) {
            if (geometries[i] == null) {
                throw new IllegalStateException(msg);
            }
            if (((Geometry)geometries[i]).isEmpty() || crs.equals(((Geometry)geometries[i]).getCoordinateReferenceSystem())) continue;
            throw new IllegalStateException("Geometries in the array do no share the same coordinate reference systems.");
        }
    }
}

