/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geolatte.geom.G2D;

public class DecimalDegree {
    private static final Pattern DMS_LON_REGEX = Pattern.compile("\\s*(\\d+)\u00b0??\\s*(\\d+)'\\s*(\\d*.??\\d*)''\\s*([EW])");
    private static final Pattern DMS_LAT_REGEX = Pattern.compile("\\s*(\\d+)\u00b0??\\s*(\\d+)'\\s*(\\d*.??\\d*)''\\s*([NS])");
    private static final double ARCSECOND_IN_RADIANS = 4.8481368111E-6;

    public static String DMS(double lon, double lat) {
        return DecimalDegree.lonDMS(lon) + " " + DecimalDegree.latDMS(lat);
    }

    public static double secondsToRadians(double v) {
        return v * 4.8481368111E-6;
    }

    public static G2D parseDMS(String dms) {
        MatchResult mr = DecimalDegree.parseDMS(dms, DMS_LON_REGEX);
        int offset = mr.matcher.end();
        double lon = mr.result;
        double lat = DecimalDegree.parseDMS((String)dms.substring((int)offset), (Pattern)DecimalDegree.DMS_LAT_REGEX).result;
        return new G2D(lon, lat);
    }

    public static double parseDMSLat(String dms) {
        return DecimalDegree.parseDMS((String)dms, (Pattern)DecimalDegree.DMS_LAT_REGEX).result;
    }

    public static double parseDMSLon(String dms) {
        return DecimalDegree.parseDMS((String)dms, (Pattern)DecimalDegree.DMS_LON_REGEX).result;
    }

    private static MatchResult parseDMS(String dms, Pattern pattern) {
        Matcher matcher = pattern.matcher(dms);
        if (!matcher.lookingAt()) {
            throw new RuntimeException(String.format("%s is Not a valid DMS String", dms));
        }
        int deg = Integer.parseInt(matcher.group(1));
        int min = Integer.parseInt(matcher.group(2));
        double secs = Double.parseDouble(matcher.group(3));
        String NWSE = matcher.group(4);
        return new MatchResult(matcher, DecimalDegree.fromDMS(deg, min, secs, NWSE));
    }

    private static String lonDMS(double lon) {
        return lon > 0.0 ? DecimalDegree.toDMS(lon) + "E" : DecimalDegree.toDMS(lon) + "W";
    }

    private static String latDMS(double lat) {
        return lat > 0.0 ? DecimalDegree.toDMS(lat) + "N" : DecimalDegree.toDMS(lat) + "S";
    }

    private static String toDMS(double c) {
        double deg = Math.floor(c);
        double mindd = (c - deg) * 60.0;
        double min = Math.floor(mindd);
        double sec = Math.round(6000.0 * (mindd - min)) / 100L;
        return String.format(Locale.ROOT, "%1$d\u00b0 %2$d' %3$.2f''", (int)deg, (int)min, sec);
    }

    private static double fromDMS(int deg, int min, double sec, String NWSE) {
        int sgn = "E".equalsIgnoreCase(NWSE) || "N".equalsIgnoreCase(NWSE) ? 1 : -1;
        return (double)(sgn * deg) + (double)min / 60.0 + sec / 3600.0;
    }

    static class MatchResult {
        Matcher matcher;
        Double result;

        MatchResult(Matcher matcher, Double result) {
            this.matcher = matcher;
            this.result = result;
        }
    }
}

