/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs;

import java.util.Arrays;
import java.util.List;
import org.geolatte.geom.C2D;
import org.geolatte.geom.crs.CartesianCoordinateSystem2DM;
import org.geolatte.geom.crs.CartesianCoordinateSystem3D;
import org.geolatte.geom.crs.CoordinateSystem;
import org.geolatte.geom.crs.CoordinateSystemAxis;
import org.geolatte.geom.crs.CoordinateSystemAxisDirection;
import org.geolatte.geom.crs.LinearUnit;
import org.geolatte.geom.crs.MeasureStraightLineAxis;
import org.geolatte.geom.crs.OneDimensionCoordinateSystem;
import org.geolatte.geom.crs.StraightLineAxis;
import org.geolatte.geom.crs.VerticalStraightLineAxis;

public class CartesianCoordinateSystem2D
extends CoordinateSystem<C2D> {
    private static final List<Integer> REQUIRED_AXIS_NORMAL_ORDER = Arrays.asList(0, 1);
    public static final CartesianCoordinateSystem2D DEFAULT = new CartesianCoordinateSystem2D(new StraightLineAxis("X", CoordinateSystemAxisDirection.EAST, LinearUnit.METER), new StraightLineAxis("Y", CoordinateSystemAxisDirection.NORTH, LinearUnit.METER));

    public CartesianCoordinateSystem2D(StraightLineAxis first, StraightLineAxis second) {
        super(first, second);
        this.checkAxes();
    }

    private void checkAxes() {
        List<Integer> order = this.getAxisNormalOrder();
        if (!order.containsAll(REQUIRED_AXIS_NORMAL_ORDER)) {
            throw new IllegalArgumentException("Require order 0 and 1 axes");
        }
    }

    @Override
    public Class<C2D> getPositionClass() {
        return C2D.class;
    }

    @Override
    public CoordinateSystem<? extends C2D> merge(OneDimensionCoordinateSystem<?> coordinateSystem) {
        CoordinateSystemAxis axis = coordinateSystem.getAxis();
        return this.extend(axis);
    }

    @Override
    public CoordinateSystem<? extends C2D> extend(CoordinateSystemAxis axis) {
        if (axis instanceof VerticalStraightLineAxis) {
            return new CartesianCoordinateSystem3D((StraightLineAxis)this.getAxis(0), (StraightLineAxis)this.getAxis(1), (VerticalStraightLineAxis)axis);
        }
        if (axis instanceof MeasureStraightLineAxis) {
            return new CartesianCoordinateSystem2DM((StraightLineAxis)this.getAxis(0), (StraightLineAxis)this.getAxis(1), (MeasureStraightLineAxis)axis);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasZ() {
        return false;
    }

    @Override
    public boolean hasM() {
        return false;
    }
}

