/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs.trans.projections;

import java.util.List;
import org.geolatte.geom.crs.CrsParameter;
import org.geolatte.geom.crs.ProjectedCoordinateReferenceSystem;
import org.geolatte.geom.crs.Projection;
import org.geolatte.geom.crs.trans.CoordinateOperation;
import org.geolatte.geom.crs.trans.CoordinateOperations;
import org.geolatte.geom.crs.trans.projections.LambertConformalConic2SP;
import org.geolatte.geom.crs.trans.projections.PseudoMercator;

public class Projections {
    public static CoordinateOperation buildFrom(ProjectedCoordinateReferenceSystem projected) {
        Projection projection = projected.getProjection();
        List<CrsParameter> params = projected.getParameters();
        if (projection.getName().equalsIgnoreCase("Lambert_Conformal_Conic_2SP") || projection.getCrsId().getCode() == 9802) {
            return LambertConformalConic2SP.fromCrsParameters(projected.getGeographicCoordinateSystem(), params);
        }
        if (projection.getName().equalsIgnoreCase("Mercator_1SP") || projection.getCrsId().getCode() == 1024) {
            return PseudoMercator.fromCrsParameters(projected.getGeographicCoordinateSystem(), params);
        }
        return CoordinateOperations.identity(2);
    }
}

