/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote;

import com.sun.enterprise.admin.remote.RemoteException;
import com.sun.enterprise.admin.remote.RemoteFailureException;
import com.sun.enterprise.admin.remote.RemoteSuccessException;
import com.sun.enterprise.admin.remote.ResponseManager;
import com.sun.enterprise.universal.NameValue;
import com.sun.enterprise.universal.glassfish.AdminCommandResponse;
import java.util.LinkedList;
import java.util.List;

class GeneratedManPageManager
implements ResponseManager {
    AdminCommandResponse response;
    private String name;
    private String synopsis;
    List<NameValue<String, String>> params = new LinkedList<NameValue<String, String>>();
    List<NameValue<String, String>> operands = new LinkedList<NameValue<String, String>>();
    private static final String TAB = "    ";
    private static final String EOL = System.getProperty("line.separator");

    GeneratedManPageManager(AdminCommandResponse response) {
        this.response = response;
    }

    public void process() throws RemoteException {
        String usageText = this.response.getValue("SYNOPSIS");
        if (usageText == null) {
            throw new RemoteFailureException("XXXXXXXXXXXXXXXXXXXX", this.response.getMainMessage());
        }
        this.setName();
        this.setSynopsis();
        this.setParamsAndOperands();
        StringBuilder sb = new StringBuilder();
        sb.append(EOL);
        this.printName(sb);
        this.printSynopsis(sb);
        this.printParams(sb);
        this.printOperands(sb);
        throw new RemoteSuccessException(sb.toString());
    }

    private void setName() {
        this.name = this.displayInProperLen(this.response.getMainMessage());
    }

    private void printName(StringBuilder sb) {
        sb.append("NAME :").append(EOL);
        sb.append(this.name).append(EOL);
    }

    private void setSynopsis() {
        this.synopsis = this.response.getValue("SYNOPSIS");
        if (this.synopsis.startsWith("Usage: ")) {
            this.synopsis = this.synopsis.substring(7);
        }
    }

    private void printSynopsis(StringBuilder sb) {
        sb.append("SYNOPSIS :").append(EOL);
        sb.append(TAB).append(this.synopsis).append(EOL);
        sb.append(EOL);
    }

    private void setParamsAndOperands() {
        List list = this.response.getMainKeys();
        for (NameValue nv : list) {
            String name = (String)nv.getName();
            if (name.equals("SYNOPSIS")) continue;
            if (name.endsWith("operand")) {
                this.operands.add((NameValue<String, String>)nv);
                continue;
            }
            this.params.add((NameValue<String, String>)nv);
        }
    }

    private void printParams(StringBuilder sb) {
        sb.append("OPTIONS :").append(EOL);
        for (NameValue<String, String> nv : this.params) {
            sb.append("    --").append((String)nv.getName()).append(EOL);
            sb.append(this.displayInProperLen((String)nv.getValue()));
            sb.append(EOL);
        }
    }

    private void printOperands(StringBuilder sb) {
        sb.append("OPERANDS :").append(EOL);
        for (NameValue<String, String> nv : this.operands) {
            String key = (String)nv.getName();
            key = key.substring(0, key.length() - 8);
            String value = (String)nv.getValue();
            sb.append(this.displayInProperLen(key + " - " + value));
            sb.append(EOL);
        }
    }

    private String displayInProperLen(String strToDisplay) {
        int index = 0;
        StringBuilder sb = new StringBuilder();
        int ii = 0;
        while (ii + 70 < strToDisplay.length()) {
            index = ii + 70;
            String subStr = strToDisplay.substring(ii, index + 1);
            if (subStr.endsWith(" ") || subStr.endsWith(",") || subStr.endsWith(".") || subStr.endsWith("-")) {
                sb.append(TAB + subStr + EOL);
                ++ii;
                ++index;
            } else {
                sb.append(TAB + strToDisplay.substring(ii, index) + "-" + EOL);
            }
            ii += 70;
        }
        if (index < strToDisplay.length()) {
            sb.append(TAB + strToDisplay.substring(index) + EOL);
        }
        return sb.toString();
    }
}

