/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.util.StringUtils;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.config.support.DomainXmlPreParser;
import org.glassfish.config.support.ServerReaderFilter;
import org.glassfish.config.support.Strings;
import org.jvnet.hk2.component.Habitat;

class InstanceReaderFilter
extends ServerReaderFilter {
    private final DomainXmlPreParser dxpp;
    private final String instanceName;

    InstanceReaderFilter(String theServerName, Habitat theHabitat, URL theDomainXml, XMLInputFactory theXif) throws XMLStreamException, DomainXmlPreParser.DomainXmlPreParserException {
        super(theHabitat, theDomainXml, theXif);
        this.instanceName = theServerName;
        this.dxpp = new DomainXmlPreParser(this.domainXml, this.xif, this.instanceName);
    }

    final boolean filterOut() throws XMLStreamException {
        try {
            XMLStreamReader reader = this.getParent();
            String elementName = reader.getLocalName();
            if (!StringUtils.ok((String)elementName)) {
                return true;
            }
            if (elementName.equals("server")) {
                return this.handleServer(reader);
            }
            if (elementName.equals("config")) {
                return this.handleConfig(reader);
            }
            if (elementName.equals("cluster")) {
                return this.handleCluster(reader);
            }
            return false;
        }
        catch (Exception e) {
            throw new XMLStreamException(Strings.get("InstanceReaderFilter.UnknownException", e.toString()), e);
        }
    }

    final String configWasFound() {
        return null;
    }

    private boolean handleServer(XMLStreamReader r) {
        String name = r.getAttributeValue(null, "name");
        return !StringUtils.ok((String)name) || !this.dxpp.getServerNames().contains(name);
    }

    private boolean handleConfig(XMLStreamReader reader) {
        String name = reader.getAttributeValue(null, "name");
        return !this.dxpp.getConfigName().equals(name);
    }

    private boolean handleCluster(XMLStreamReader reader) {
        String name = reader.getAttributeValue(null, "name");
        String myCluster = this.dxpp.getClusterName();
        return !StringUtils.ok((String)myCluster) || !myCluster.equals(name);
    }
}

